/******************************************************************************

	conn.h -- create outgoing network connections
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: conn.h 223 2011-12-02 10:53:44Z wsl $
	$URL: https://svn.fair.uvt.nl/branches/0.5/src/conn.h $

******************************************************************************/
#ifndef CONN_H
#define CONN_H

#include <sys/socket.h>
#include <avl.h>

#include "address.h"
#include "fd.h"

struct connector;

typedef void (*connect_hook_t)(struct connector *, fd_t *);

typedef struct connector {
	avl_node_t node;
	fd_t *fd;
	connect_hook_t func;
	void *data;
} connector_t;

extern unsigned int connector_count(void);
extern connector_t *connector_new(const address_t *, connect_hook_t, void *);
extern void connector_delete(connector_t *);

#endif
