/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.enumerations.CoordinateType;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.gui.MSP_GEOTRANS3;
import geotrans3.gui.MasterPanel;
import geotrans3.misc.FormatOptions;
import geotrans3.parameters.CoordinateSystemParameters;
import geotrans3.parameters.EquidistantCylindricalParameters;
import geotrans3.parameters.GeodeticParameters;
import geotrans3.parameters.LocalCartesianParameters;
import geotrans3.parameters.MapProjection3Parameters;
import geotrans3.parameters.MapProjection4Parameters;
import geotrans3.parameters.MapProjection5Parameters;
import geotrans3.parameters.MapProjection6Parameters;
import geotrans3.parameters.MercatorScaleFactorParameters;
import geotrans3.parameters.MercatorStandardParallelParameters;
import geotrans3.parameters.NeysParameters;
import geotrans3.parameters.ObliqueMercatorParameters;
import geotrans3.parameters.PolarStereographicScaleFactorParameters;
import geotrans3.parameters.PolarStereographicStandardParallelParameters;
import geotrans3.parameters.UTMParameters;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoadSettings {
    private MSP_GEOTRANS3 parent;
    private File file;
    private MasterPanel upperMasterPanel;
    private MasterPanel lowerMasterPanel;
    private FormatOptions joptions;
    int defaultSourceDatum;
    String defaultSourceDatumCode;
    String defaultSourceProjectionCode;
    private CoordinateSystemParameters defaultSourceParameters;
    int defaultTargetDatum;
    String defaultTargetDatumCode;
    String defaultTargetProjectionCode;
    private CoordinateSystemParameters defaultTargetParameters;

    public LoadSettings(MSP_GEOTRANS3 mSP_GEOTRANS3, File file) {
        this.parent = mSP_GEOTRANS3;
        this.file = file;
    }

    public FormatOptions getDefaultFormatOptions() {
        return this.joptions;
    }

    public int getDefaultSourceDatum() {
        return this.defaultSourceDatum;
    }

    public String getDefaultSourceDatumCode() {
        return this.defaultSourceDatumCode;
    }

    public int getDefaultTargetDatum() {
        return this.defaultTargetDatum;
    }

    public String getDefaultTargetDatumCode() {
        return this.defaultTargetDatumCode;
    }

    public String getDefaultSourceProjectionCode() {
        return this.defaultSourceProjectionCode;
    }

    public String getDefaultTargetProjectionCode() {
        return this.defaultTargetProjectionCode;
    }

    public CoordinateSystemParameters getDefaultSourceParameters() {
        return this.defaultSourceParameters;
    }

    public CoordinateSystemParameters getDefaultTargetParameters() {
        return this.defaultTargetParameters;
    }

    public void readDefaults() throws CoordinateConversionException {
        try {
            Node node;
            NodeList nodeList;
            Object object;
            Node node2;
            NodeList nodeList2;
            Node node3;
            NodeList nodeList3;
            Node node4;
            NodeList nodeList4;
            Node node5;
            NodeList nodeList5;
            Element element;
            Object object2;
            Object object3;
            this.defaultSourceDatum = 0;
            this.defaultSourceDatumCode = "";
            this.defaultSourceProjectionCode = "";
            this.defaultTargetDatum = 0;
            this.defaultTargetDatumCode = "";
            this.defaultTargetProjectionCode = "";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.file);
            document.getDocumentElement().normalize();
            this.readOptions(document);
            NodeList nodeList6 = document.getElementsByTagName("source");
            Node node6 = nodeList6.item(0);
            if (node6.getNodeType() == 1) {
                object3 = (Element)node6;
                object2 = object3.getElementsByTagName("datum");
                element = (Element)object2.item(0);
                nodeList5 = element.getElementsByTagName("index");
                node5 = nodeList5.item(0).getLastChild();
                this.defaultSourceDatum = Integer.parseInt(node5.getNodeValue().trim());
                nodeList4 = element.getElementsByTagName("code");
                node4 = nodeList4.item(0).getLastChild();
                this.defaultSourceDatumCode = node4.getNodeValue().trim();
                nodeList3 = object3.getElementsByTagName("projection");
                node3 = (Element)nodeList3.item(0);
                nodeList2 = node3.getElementsByTagName("index");
                node2 = nodeList2.item(0).getLastChild();
                int n = Integer.parseInt(node2.getNodeValue().trim());
                object = node3.getElementsByTagName("code");
                Node node7 = object.item(0).getLastChild();
                this.defaultSourceProjectionCode = node7.getNodeValue().trim();
                nodeList = object3.getElementsByTagName("parameters");
                node = (Element)nodeList.item(0);
                this.defaultSourceParameters = this.readParameters(this.defaultSourceProjectionCode, (Element)node);
            }
            if ((object2 = (object3 = document.getElementsByTagName("target")).item(0)).getNodeType() == 1) {
                element = (Element)object2;
                nodeList5 = element.getElementsByTagName("datum");
                node5 = (Element)nodeList5.item(0);
                nodeList4 = node5.getElementsByTagName("index");
                node4 = nodeList4.item(0).getLastChild();
                this.defaultTargetDatum = Integer.parseInt(node4.getNodeValue().trim());
                nodeList3 = node5.getElementsByTagName("code");
                node3 = nodeList3.item(0).getLastChild();
                this.defaultTargetDatumCode = node3.getNodeValue().trim();
                nodeList2 = element.getElementsByTagName("projection");
                node2 = (Element)nodeList2.item(0);
                NodeList nodeList7 = node2.getElementsByTagName("index");
                object = nodeList7.item(0).getLastChild();
                int n = Integer.parseInt(object.getNodeValue().trim());
                nodeList = node2.getElementsByTagName("code");
                node = nodeList.item(0).getLastChild();
                this.defaultTargetProjectionCode = node.getNodeValue().trim();
                NodeList nodeList8 = element.getElementsByTagName("parameters");
                Element element2 = (Element)nodeList8.item(0);
                this.defaultTargetParameters = this.readParameters(this.defaultTargetProjectionCode, element2);
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println(" " + sAXParseException.getMessage());
            throw new CoordinateConversionException("Error parsing " + this.file + " file");
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            (exception == null ? sAXException : exception).printStackTrace();
            throw new CoordinateConversionException("Error parsing " + this.file + " file");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new CoordinateConversionException("Error parsing " + this.file + " file");
        }
    }

    private void readOptions(Document document) {
        NodeList nodeList = document.getElementsByTagName("options");
        Node node = nodeList.item(0);
        if (node.getNodeType() == 1) {
            this.joptions = new FormatOptions();
            Element element = (Element)node;
            NodeList nodeList2 = element.getElementsByTagName("units");
            Element element2 = (Element)nodeList2.item(0);
            NodeList nodeList3 = element2.getElementsByTagName("index");
            Node node2 = nodeList3.item(0).getLastChild();
            int n = Integer.parseInt(node2.getNodeValue().trim());
            NodeList nodeList4 = element2.getElementsByTagName("value");
            Node node3 = nodeList4.item(0).getLastChild();
            String string = node3.getNodeValue().trim();
            this.joptions.setUnits(n);
            NodeList nodeList5 = element.getElementsByTagName("separator");
            Element element3 = (Element)nodeList5.item(0);
            NodeList nodeList6 = element3.getElementsByTagName("index");
            Node node4 = nodeList6.item(0).getLastChild();
            int n2 = Integer.parseInt(node4.getNodeValue().trim());
            NodeList nodeList7 = element3.getElementsByTagName("value");
            Node node5 = nodeList7.item(0).getLastChild();
            String string2 = node5.getNodeValue().trim();
            this.joptions.setSeparator(n2);
            NodeList nodeList8 = element.getElementsByTagName("signHemisphere");
            Element element4 = (Element)nodeList8.item(0);
            NodeList nodeList9 = element4.getElementsByTagName("index");
            Node node6 = nodeList9.item(0).getLastChild();
            int n3 = Integer.parseInt(node6.getNodeValue().trim());
            NodeList nodeList10 = element4.getElementsByTagName("value");
            Node node7 = nodeList10.item(0).getLastChild();
            String string3 = node7.getNodeValue().trim();
            this.joptions.setSignHemi(n3);
            NodeList nodeList11 = element.getElementsByTagName("longitudeRange");
            Element element5 = (Element)nodeList11.item(0);
            NodeList nodeList12 = element5.getElementsByTagName("index");
            Node node8 = nodeList12.item(0).getLastChild();
            int n4 = Integer.parseInt(node8.getNodeValue().trim());
            NodeList nodeList13 = element5.getElementsByTagName("value");
            Node node9 = nodeList13.item(0).getLastChild();
            String string4 = node9.getNodeValue().trim();
            this.joptions.setRange(n4);
            NodeList nodeList14 = element.getElementsByTagName("precision");
            Element element6 = (Element)nodeList14.item(0);
            NodeList nodeList15 = element6.getElementsByTagName("index");
            Node node10 = nodeList15.item(0).getLastChild();
            int n5 = Integer.parseInt(node10.getNodeValue().trim());
            NodeList nodeList16 = element6.getElementsByTagName("value");
            Node node11 = nodeList16.item(0).getLastChild();
            String string5 = node11.getNodeValue().trim();
            this.joptions.setPrecision(n5);
            NodeList nodeList17 = element.getElementsByTagName("leadingZeros");
            Element element7 = (Element)nodeList17.item(0);
            NodeList nodeList18 = element7.getElementsByTagName("value");
            Node node12 = nodeList18.item(0).getLastChild();
            boolean bl = Boolean.valueOf(node12.getNodeValue().trim());
            this.joptions.setLeadingZeros(bl);
            NodeList nodeList19 = element.getElementsByTagName("heightUnit");
            Element element8 = (Element)nodeList19.item(0);
            NodeList nodeList20 = element8.getElementsByTagName("value");
            Node node13 = nodeList20.item(0).getLastChild();
            int n6 = Integer.valueOf(node13.getNodeValue().trim());
            this.joptions.setHeightUnit(n6);
        }
    }

    private CoordinateSystemParameters readParameters(String string, Element element) throws CoordinateConversionException {
        int n = CoordinateType.codeIndex(string);
        switch (n) {
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 29: 
            case 36: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList2 = element.getElementsByTagName("falseEasting");
                Node node2 = nodeList2.item(0).getLastChild();
                double d2 = Double.parseDouble(node2.getNodeValue().trim());
                NodeList nodeList3 = element.getElementsByTagName("falseNorthing");
                Node node3 = nodeList3.item(0).getLastChild();
                double d3 = Double.parseDouble(node3.getNodeValue().trim());
                return new MapProjection3Parameters(n, d, d2, d3);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 25: 
            case 28: 
            case 30: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList4 = element.getElementsByTagName("originLatitude");
                Node node4 = nodeList4.item(0).getLastChild();
                double d4 = Double.parseDouble(node4.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList5 = element.getElementsByTagName("falseEasting");
                Node node5 = nodeList5.item(0).getLastChild();
                double d5 = Double.parseDouble(node5.getNodeValue().trim());
                NodeList nodeList6 = element.getElementsByTagName("falseNorthing");
                Node node6 = nodeList6.item(0).getLastChild();
                double d6 = Double.parseDouble(node6.getNodeValue().trim());
                return new MapProjection4Parameters(n, d, d4, d5, d6);
            }
            case 8: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList7 = element.getElementsByTagName("standardParallel");
                Node node7 = nodeList7.item(0).getLastChild();
                double d7 = Double.parseDouble(node7.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList8 = element.getElementsByTagName("falseEasting");
                Node node8 = nodeList8.item(0).getLastChild();
                double d8 = Double.parseDouble(node8.getNodeValue().trim());
                NodeList nodeList9 = element.getElementsByTagName("falseNorthing");
                Node node9 = nodeList9.item(0).getLastChild();
                double d9 = Double.parseDouble(node9.getNodeValue().trim());
                return new EquidistantCylindricalParameters(n, d, d7, d8, d9);
            }
            case 14: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList10 = element.getElementsByTagName("originLatitude");
                Node node10 = nodeList10.item(0).getLastChild();
                double d10 = Double.parseDouble(node10.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList11 = element.getElementsByTagName("scaleFactor");
                Node node11 = nodeList11.item(0).getLastChild();
                double d11 = Double.parseDouble(node11.getNodeValue().trim());
                NodeList nodeList12 = element.getElementsByTagName("falseEasting");
                Node node12 = nodeList12.item(0).getLastChild();
                double d12 = Double.parseDouble(node12.getNodeValue().trim());
                NodeList nodeList13 = element.getElementsByTagName("falseNorthing");
                Node node13 = nodeList13.item(0).getLastChild();
                double d13 = Double.parseDouble(node13.getNodeValue().trim());
                return new MapProjection5Parameters(n, d, d10, d11, d12, d13);
            }
            case 31: 
            case 32: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList14 = element.getElementsByTagName("originLatitude");
                Node node14 = nodeList14.item(0).getLastChild();
                double d14 = Double.parseDouble(node14.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList15 = element.getElementsByTagName("scaleFactor");
                Node node15 = nodeList15.item(0).getLastChild();
                double d15 = Double.parseDouble(node15.getNodeValue().trim());
                NodeList nodeList16 = element.getElementsByTagName("falseEasting");
                Node node16 = nodeList16.item(0).getLastChild();
                double d16 = Double.parseDouble(node16.getNodeValue().trim());
                NodeList nodeList17 = element.getElementsByTagName("falseNorthing");
                Node node17 = nodeList17.item(0).getLastChild();
                double d17 = Double.parseDouble(node17.getNodeValue().trim());
                return new MapProjection5Parameters(n, d, d14, d15, d16, d17);
            }
            case 17: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList18 = element.getElementsByTagName("standardParallel");
                Node node18 = nodeList18.item(0).getLastChild();
                double d18 = Double.parseDouble(node18.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList19 = element.getElementsByTagName("scaleFactor");
                Node node19 = nodeList19.item(0).getLastChild();
                double d19 = Double.parseDouble(node19.getNodeValue().trim());
                NodeList nodeList20 = element.getElementsByTagName("falseEasting");
                Node node20 = nodeList20.item(0).getLastChild();
                double d20 = Double.parseDouble(node20.getNodeValue().trim());
                NodeList nodeList21 = element.getElementsByTagName("falseNorthing");
                Node node21 = nodeList21.item(0).getLastChild();
                double d21 = Double.parseDouble(node21.getNodeValue().trim());
                return new MercatorStandardParallelParameters(n, d, d18, d19, d20, d21);
            }
            case 18: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList22 = element.getElementsByTagName("scaleFactor");
                Node node22 = nodeList22.item(0).getLastChild();
                double d22 = Double.parseDouble(node22.getNodeValue().trim());
                NodeList nodeList23 = element.getElementsByTagName("falseEasting");
                Node node23 = nodeList23.item(0).getLastChild();
                double d23 = Double.parseDouble(node23.getNodeValue().trim());
                NodeList nodeList24 = element.getElementsByTagName("falseNorthing");
                Node node24 = nodeList24.item(0).getLastChild();
                double d24 = Double.parseDouble(node24.getNodeValue().trim());
                return new MercatorScaleFactorParameters(n, d, d22, d23, d24);
            }
            case 0: 
            case 15: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList25 = element.getElementsByTagName("originLatitude");
                Node node25 = nodeList25.item(0).getLastChild();
                double d25 = Double.parseDouble(node25.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList26 = element.getElementsByTagName("standardParallel1");
                Node node26 = nodeList26.item(0).getLastChild();
                double d26 = Double.parseDouble(node26.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList27 = element.getElementsByTagName("standardParallel2");
                Node node27 = nodeList27.item(0).getLastChild();
                double d27 = Double.parseDouble(node27.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList28 = element.getElementsByTagName("falseEasting");
                Node node28 = nodeList28.item(0).getLastChild();
                double d28 = Double.parseDouble(node28.getNodeValue().trim());
                NodeList nodeList29 = element.getElementsByTagName("falseNorthing");
                Node node29 = nodeList29.item(0).getLastChild();
                double d29 = Double.parseDouble(node29.getNodeValue().trim());
                return new MapProjection6Parameters(n, d, d25, d26, d27, d28, d29);
            }
            case 16: {
                NodeList nodeList = element.getElementsByTagName("originLongitude");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList30 = element.getElementsByTagName("originLatitude");
                Node node30 = nodeList30.item(0).getLastChild();
                double d30 = Double.parseDouble(node30.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList31 = element.getElementsByTagName("originHeight");
                Node node31 = nodeList31.item(0).getLastChild();
                double d31 = Double.parseDouble(node31.getNodeValue().trim());
                NodeList nodeList32 = element.getElementsByTagName("orientation");
                Node node32 = nodeList32.item(0).getLastChild();
                double d32 = Double.parseDouble(node32.getNodeValue().trim()) * (Math.PI / 180);
                return new LocalCartesianParameters(n, d, d30, d31, d32);
            }
            case 23: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList33 = element.getElementsByTagName("originLatitude");
                Node node33 = nodeList33.item(0).getLastChild();
                double d33 = Double.parseDouble(node33.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList34 = element.getElementsByTagName("standardParallel1");
                Node node34 = nodeList34.item(0).getLastChild();
                double d34 = Double.parseDouble(node34.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList35 = element.getElementsByTagName("falseEasting");
                Node node35 = nodeList35.item(0).getLastChild();
                double d35 = Double.parseDouble(node35.getNodeValue().trim());
                NodeList nodeList36 = element.getElementsByTagName("falseNorthing");
                Node node36 = nodeList36.item(0).getLastChild();
                double d36 = Double.parseDouble(node36.getNodeValue().trim());
                return new NeysParameters(n, d, d33, d34, d35, d36);
            }
            case 24: {
                NodeList nodeList = element.getElementsByTagName("originLatitude");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList37 = element.getElementsByTagName("scaleFactor");
                Node node37 = nodeList37.item(0).getLastChild();
                double d37 = Double.parseDouble(node37.getNodeValue().trim());
                NodeList nodeList38 = element.getElementsByTagName("longitude1");
                Node node38 = nodeList38.item(0).getLastChild();
                double d38 = Double.parseDouble(node38.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList39 = element.getElementsByTagName("latitude1");
                Node node39 = nodeList39.item(0).getLastChild();
                double d39 = Double.parseDouble(node39.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList40 = element.getElementsByTagName("longitude2");
                Node node40 = nodeList40.item(0).getLastChild();
                double d40 = Double.parseDouble(node40.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList41 = element.getElementsByTagName("latitude2");
                Node node41 = nodeList41.item(0).getLastChild();
                double d41 = Double.parseDouble(node41.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList42 = element.getElementsByTagName("falseEasting");
                Node node42 = nodeList42.item(0).getLastChild();
                double d42 = Double.parseDouble(node42.getNodeValue().trim());
                NodeList nodeList43 = element.getElementsByTagName("falseNorthing");
                Node node43 = nodeList43.item(0).getLastChild();
                double d43 = Double.parseDouble(node43.getNodeValue().trim());
                return new ObliqueMercatorParameters(n, d, d38, d39, d40, d41, d42, d43, d37);
            }
            case 26: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList44 = element.getElementsByTagName("standardParallel");
                Node node44 = nodeList44.item(0).getLastChild();
                double d44 = Double.parseDouble(node44.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList45 = element.getElementsByTagName("falseEasting");
                Node node45 = nodeList45.item(0).getLastChild();
                double d45 = Double.parseDouble(node45.getNodeValue().trim());
                NodeList nodeList46 = element.getElementsByTagName("falseNorthing");
                Node node46 = nodeList46.item(0).getLastChild();
                double d46 = Double.parseDouble(node46.getNodeValue().trim());
                return new PolarStereographicStandardParallelParameters(n, d, d44, d45, d46);
            }
            case 27: {
                NodeList nodeList = element.getElementsByTagName("centralMeridian");
                Node node = nodeList.item(0).getLastChild();
                double d = Double.parseDouble(node.getNodeValue().trim()) * (Math.PI / 180);
                NodeList nodeList47 = element.getElementsByTagName("scaleFactor");
                Node node47 = nodeList47.item(0).getLastChild();
                double d47 = Double.parseDouble(node47.getNodeValue().trim());
                NodeList nodeList48 = element.getElementsByTagName("hemisphere");
                Node node48 = nodeList48.item(0).getLastChild();
                char c = node48.getNodeValue().trim().charAt(0);
                NodeList nodeList49 = element.getElementsByTagName("falseEasting");
                Node node49 = nodeList49.item(0).getLastChild();
                double d48 = Double.parseDouble(node49.getNodeValue().trim());
                NodeList nodeList50 = element.getElementsByTagName("falseNorthing");
                Node node50 = nodeList50.item(0).getLastChild();
                double d49 = Double.parseDouble(node50.getNodeValue().trim());
                return new PolarStereographicScaleFactorParameters(n, d, d47, c, d48, d49);
            }
            case 10: {
                NodeList nodeList = element.getElementsByTagName("heightType");
                Node node = nodeList.item(0).getLastChild();
                int n2 = Integer.parseInt(node.getNodeValue().trim());
                return new GeodeticParameters(n, n2);
            }
            case 34: {
                NodeList nodeList = element.getElementsByTagName("override");
                Node node = nodeList.item(0).getLastChild();
                int n3 = Integer.parseInt(node.getNodeValue().trim());
                NodeList nodeList51 = element.getElementsByTagName("zone");
                Node node51 = nodeList51.item(0).getLastChild();
                int n4 = Integer.parseInt(node51.getNodeValue().trim());
                return new UTMParameters(n, n4, n3);
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 22: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                return new CoordinateSystemParameters(n);
            }
        }
        throw new CoordinateConversionException("Invalid coordinate type");
    }
}

