//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbilling

import "time"

// Account - A billing account.
type Account struct {
	// The properties of the billing account.
	Properties *AccountProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountListResult - The list of billing accounts.
type AccountListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing accounts.
	Value []*Account `json:"value,omitempty" azure:"ro"`
}

// AccountProperties - The properties of the billing account.
type AccountProperties struct {
	// The billing profiles associated with the billing account. By default this is not populated, unless it's specified in $expand.
	BillingProfiles *ProfilesOnExpand `json:"billingProfiles,omitempty"`

	// The departments associated to the enrollment.
	Departments []*Department `json:"departments,omitempty"`

	// The billing account name.
	DisplayName *string `json:"displayName,omitempty"`

	// The accounts associated to the enrollment.
	EnrollmentAccounts []*EnrollmentAccount `json:"enrollmentAccounts,omitempty"`

	// Notification email address, only for legacy accounts
	NotificationEmailAddress *string `json:"notificationEmailAddress,omitempty"`

	// The address of the individual or organization that is responsible for the billing account.
	SoldTo *AddressDetails `json:"soldTo,omitempty"`

	// READ-ONLY; The current status of the billing account.
	AccountStatus *AccountStatus `json:"accountStatus,omitempty" azure:"ro"`

	// READ-ONLY; The type of customer.
	AccountType *AccountType `json:"accountType,omitempty" azure:"ro"`

	// READ-ONLY; The type of agreement.
	AgreementType *AgreementType `json:"agreementType,omitempty" azure:"ro"`

	// READ-ONLY; The details about the associated legacy enrollment. By default this is not populated, unless it's specified
	// in $expand.
	EnrollmentDetails *Enrollment `json:"enrollmentDetails,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether user has read access to the billing account.
	HasReadAccess *bool `json:"hasReadAccess,omitempty" azure:"ro"`
}

// AccountUpdateRequest - The request properties of the billing account that can be updated.
type AccountUpdateRequest struct {
	// A billing property.
	Properties *AccountProperties `json:"properties,omitempty"`
}

// AccountsClientBeginUpdateOptions contains the optional parameters for the AccountsClient.BeginUpdate method.
type AccountsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// May be used to expand the soldTo, invoice sections and billing profiles.
	Expand *string
}

// AccountsClientListInvoiceSectionsByCreateSubscriptionPermissionOptions contains the optional parameters for the AccountsClient.ListInvoiceSectionsByCreateSubscriptionPermission
// method.
type AccountsClientListInvoiceSectionsByCreateSubscriptionPermissionOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.List method.
type AccountsClientListOptions struct {
	// May be used to expand the soldTo, invoice sections and billing profiles.
	Expand *string
}

// AddressClientValidateOptions contains the optional parameters for the AddressClient.Validate method.
type AddressClientValidateOptions struct {
	// placeholder for future optional parameters
}

// AddressDetails - Address details.
type AddressDetails struct {
	// REQUIRED; Address line 1.
	AddressLine1 *string `json:"addressLine1,omitempty"`

	// REQUIRED; Country code uses ISO2, 2-digit format.
	Country *string `json:"country,omitempty"`

	// Address line 2.
	AddressLine2 *string `json:"addressLine2,omitempty"`

	// Address line 3.
	AddressLine3 *string `json:"addressLine3,omitempty"`

	// Address city.
	City *string `json:"city,omitempty"`

	// Company name.
	CompanyName *string `json:"companyName,omitempty"`

	// Address district.
	District *string `json:"district,omitempty"`

	// Email address.
	Email *string `json:"email,omitempty"`

	// First name.
	FirstName *string `json:"firstName,omitempty"`

	// Last name.
	LastName *string `json:"lastName,omitempty"`

	// Middle name.
	MiddleName *string `json:"middleName,omitempty"`

	// Phone number.
	PhoneNumber *string `json:"phoneNumber,omitempty"`

	// Postal code.
	PostalCode *string `json:"postalCode,omitempty"`

	// Address region.
	Region *string `json:"region,omitempty"`
}

// Agreement - An agreement.
type Agreement struct {
	// The properties of an agreement.
	Properties *AgreementProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgreementListResult - Result of listing agreements.
type AgreementListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of agreements.
	Value []*Agreement `json:"value,omitempty" azure:"ro"`
}

// AgreementProperties - The properties of an agreement.
type AgreementProperties struct {
	// The list of participants that participates in acceptance of an agreement.
	Participants []*Participants `json:"participants,omitempty"`

	// READ-ONLY; The mode of acceptance for an agreement.
	AcceptanceMode *AcceptanceMode `json:"acceptanceMode,omitempty" azure:"ro"`

	// READ-ONLY; The URL to download the agreement.
	AgreementLink *string `json:"agreementLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing profiles associated with agreement and present only for specific agreements.
	BillingProfileInfo *ProfileInfo `json:"billingProfileInfo,omitempty" azure:"ro"`

	// READ-ONLY; The category of the agreement signed by a customer.
	Category *Category `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; The date from which the agreement is effective.
	EffectiveDate *time.Time `json:"effectiveDate,omitempty" azure:"ro"`

	// READ-ONLY; The date when the agreement expires.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the agreement.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// AgreementsClientGetOptions contains the optional parameters for the AgreementsClient.Get method.
type AgreementsClientGetOptions struct {
	// May be used to expand the participants.
	Expand *string
}

// AgreementsClientListByBillingAccountOptions contains the optional parameters for the AgreementsClient.ListByBillingAccount
// method.
type AgreementsClientListByBillingAccountOptions struct {
	// May be used to expand the participants.
	Expand *string
}

// Amount - The amount.
type Amount struct {
	// Amount value.
	Value *float32 `json:"value,omitempty"`

	// READ-ONLY; The currency for the amount value.
	Currency *string `json:"currency,omitempty" azure:"ro"`
}

// AvailableBalance - The latest Azure credit balance. This is the balance available for pay now.
type AvailableBalance struct {
	// The properties of available balance.
	Properties *AvailableBalanceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AvailableBalanceProperties - The properties of available balance.
type AvailableBalanceProperties struct {
	// READ-ONLY; Balance amount.
	Amount *Amount `json:"amount,omitempty" azure:"ro"`
}

// AvailableBalancesClientGetOptions contains the optional parameters for the AvailableBalancesClient.Get method.
type AvailableBalancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AzurePlan - Details of the Azure plan.
type AzurePlan struct {
	// The sku id.
	SKUID *string `json:"skuId,omitempty"`

	// READ-ONLY; The sku description.
	SKUDescription *string `json:"skuDescription,omitempty" azure:"ro"`
}

// Customer - A partner's customer.
type Customer struct {
	// The customer.
	Properties *CustomerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomerListResult - The list of customers.
type CustomerListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of customers.
	Value []*Customer `json:"value,omitempty" azure:"ro"`
}

// CustomerPolicy - The customer's Policy.
type CustomerPolicy struct {
	// The properties of a customer's policy.
	Properties *CustomerPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomerPolicyProperties - The properties of a customer's policy.
type CustomerPolicyProperties struct {
	// The policy that controls whether the users in customer's organization can view charges at pay-as-you-go prices.
	ViewCharges *ViewCharges `json:"viewCharges,omitempty"`
}

// CustomerProperties - The properties of a customer.
type CustomerProperties struct {
	// The name of the customer.
	DisplayName *string `json:"displayName,omitempty"`

	// Azure plans enabled for the customer.
	EnabledAzurePlans []*AzurePlan `json:"enabledAzurePlans,omitempty"`

	// The list of resellers for which an Azure plan is enabled for the customer.
	Resellers []*Reseller `json:"resellers,omitempty"`

	// READ-ONLY; The name of the billing profile for the invoice section.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile for the invoice section.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`
}

// CustomersClientGetOptions contains the optional parameters for the CustomersClient.Get method.
type CustomersClientGetOptions struct {
	// May be used to expand enabledAzurePlans and resellers
	Expand *string
}

// CustomersClientListByBillingAccountOptions contains the optional parameters for the CustomersClient.ListByBillingAccount
// method.
type CustomersClientListByBillingAccountOptions struct {
	// May be used to filter the list of customers.
	Filter *string
	// Used for searching customers by their name. Any customer with name containing the search text will be included in the response
	Search *string
}

// CustomersClientListByBillingProfileOptions contains the optional parameters for the CustomersClient.ListByBillingProfile
// method.
type CustomersClientListByBillingProfileOptions struct {
	// May be used to filter the list of customers.
	Filter *string
	// Used for searching customers by their name. Any customer with name containing the search text will be included in the response
	Search *string
}

// Department - A department.
type Department struct {
	// A department.
	Properties *DepartmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DepartmentProperties - The properties of a department.
type DepartmentProperties struct {
	// The cost center associated with the department.
	CostCenter *string `json:"costCenter,omitempty"`

	// The name of the department.
	DepartmentName *string `json:"departmentName,omitempty"`

	// Associated enrollment accounts. By default this is not populated, unless it's specified in $expand.
	EnrollmentAccounts []*EnrollmentAccount `json:"enrollmentAccounts,omitempty"`

	// The status of the department.
	Status *string `json:"status,omitempty"`
}

// Document - The properties of a document.
type Document struct {
	// READ-ONLY; The type of the document.
	Kind *DocumentType `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The source of the document. ENF for Brazil and DRS for rest of the world.
	Source *DocumentSource `json:"source,omitempty" azure:"ro"`

	// READ-ONLY; Document URL.
	URL *string `json:"url,omitempty" azure:"ro"`
}

// DownloadURL - A secure URL that can be used to download a an entity until the URL expires.
type DownloadURL struct {
	// READ-ONLY; The time in UTC when the download URL will expire.
	ExpiryTime *time.Time `json:"expiryTime,omitempty" azure:"ro"`

	// READ-ONLY; The URL to the PDF file.
	URL *string `json:"url,omitempty" azure:"ro"`
}

// Enrollment - The properties of an enrollment.
type Enrollment struct {
	// The end date of the enrollment.
	EndDate *time.Time `json:"endDate,omitempty"`

	// The start date of the enrollment.
	StartDate *time.Time `json:"startDate,omitempty"`

	// READ-ONLY; The billing cycle for the enrollment.
	BillingCycle *string `json:"billingCycle,omitempty" azure:"ro"`

	// READ-ONLY; The channel type of the enrollment.
	Channel *string `json:"channel,omitempty" azure:"ro"`

	// READ-ONLY; The country code of the enrollment.
	CountryCode *string `json:"countryCode,omitempty" azure:"ro"`

	// READ-ONLY; The billing currency for the enrollment.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; The language for the enrollment.
	Language *string `json:"language,omitempty" azure:"ro"`

	// READ-ONLY; The policies for Enterprise Agreement enrollments.
	Policies *EnrollmentPolicies `json:"policies,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the enrollment.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// EnrollmentAccount - An enrollment account.
type EnrollmentAccount struct {
	// The properties of an enrollment account.
	Properties *EnrollmentAccountProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnrollmentAccountContext - The enrollment account context
type EnrollmentAccountContext struct {
	// The cost center associated with the enrollment account.
	CostCenter *string `json:"costCenter,omitempty"`

	// The end date of the enrollment account.
	EndDate *time.Time `json:"endDate,omitempty"`

	// The ID of the enrollment account.
	EnrollmentAccountName *string `json:"enrollmentAccountName,omitempty"`

	// The start date of the enrollment account.
	StartDate *time.Time `json:"startDate,omitempty"`
}

// EnrollmentAccountListResult - Result of listing enrollment accounts.
type EnrollmentAccountListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of enrollment accounts.
	Value []*EnrollmentAccountSummary `json:"value,omitempty" azure:"ro"`
}

// EnrollmentAccountProperties - The properties of an enrollment account.
type EnrollmentAccountProperties struct {
	// The name of the enrollment account.
	AccountName *string `json:"accountName,omitempty"`

	// The owner of the enrollment account.
	AccountOwner *string `json:"accountOwner,omitempty"`

	// The enrollment account owner email address.
	AccountOwnerEmail *string `json:"accountOwnerEmail,omitempty"`

	// The cost center associated with the enrollment account.
	CostCenter *string `json:"costCenter,omitempty"`

	// Associated department. By default this is not populated, unless it's specified in $expand.
	Department *Department `json:"department,omitempty"`

	// The end date of the enrollment account.
	EndDate *time.Time `json:"endDate,omitempty"`

	// The start date of the enrollment account.
	StartDate *time.Time `json:"startDate,omitempty"`

	// The status of the enrollment account.
	Status *string `json:"status,omitempty"`
}

// EnrollmentAccountSummary - An enrollment account resource.
type EnrollmentAccountSummary struct {
	// An enrollment account.
	Properties *EnrollmentAccountSummaryProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnrollmentAccountSummaryProperties - The properties of the enrollment account.
type EnrollmentAccountSummaryProperties struct {
	// READ-ONLY; The account owner's principal name.
	PrincipalName *string `json:"principalName,omitempty" azure:"ro"`
}

// EnrollmentAccountsClientGetOptions contains the optional parameters for the EnrollmentAccountsClient.Get method.
type EnrollmentAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EnrollmentAccountsClientListOptions contains the optional parameters for the EnrollmentAccountsClient.List method.
type EnrollmentAccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// EnrollmentPolicies - The policies for Enterprise Agreement enrollments.
type EnrollmentPolicies struct {
	// READ-ONLY; The policy that controls whether Account Owners can view charges.
	AccountOwnerViewCharges *bool `json:"accountOwnerViewCharges,omitempty" azure:"ro"`

	// READ-ONLY; The policy that controls whether Department Administrators can view charges.
	DepartmentAdminViewCharges *bool `json:"departmentAdminViewCharges,omitempty" azure:"ro"`

	// READ-ONLY; The policy that controls whether Azure marketplace purchases are allowed in the enrollment.
	MarketplaceEnabled *bool `json:"marketplaceEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The policy that controls whether Azure reservation purchases are allowed in the enrollment.
	ReservedInstancesEnabled *bool `json:"reservedInstancesEnabled,omitempty" azure:"ro"`
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The sub details of the error.
	Details []*ErrorSubDetailsItem `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

type ErrorSubDetailsItem struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// IndirectRelationshipInfo - The billing profile details of the partner of the customer for an indirect motion.
type IndirectRelationshipInfo struct {
	// The billing account name of the partner or the customer for an indirect motion.
	BillingAccountName *string `json:"billingAccountName,omitempty"`

	// The billing profile name of the partner or the customer for an indirect motion.
	BillingProfileName *string `json:"billingProfileName,omitempty"`

	// The display name of the partner or customer for an indirect motion.
	DisplayName *string `json:"displayName,omitempty"`
}

// Instruction - An instruction.
type Instruction struct {
	// A billing instruction used during invoice generation.
	Properties *InstructionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InstructionListResult - The list of billing instructions used during invoice generation.
type InstructionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing instructions used during invoice generation.
	Value []*Instruction `json:"value,omitempty" azure:"ro"`
}

// InstructionProperties - A billing instruction used during invoice generation.
type InstructionProperties struct {
	// REQUIRED; The amount budgeted for this billing instruction.
	Amount *float32 `json:"amount,omitempty"`

	// REQUIRED; The date this billing instruction is no longer in effect.
	EndDate *time.Time `json:"endDate,omitempty"`

	// REQUIRED; The date this billing instruction goes into effect.
	StartDate *time.Time `json:"startDate,omitempty"`

	// The date this billing instruction was created.
	CreationDate *time.Time `json:"creationDate,omitempty"`
}

// InstructionsClientGetOptions contains the optional parameters for the InstructionsClient.Get method.
type InstructionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InstructionsClientListByBillingProfileOptions contains the optional parameters for the InstructionsClient.ListByBillingProfile
// method.
type InstructionsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// InstructionsClientPutOptions contains the optional parameters for the InstructionsClient.Put method.
type InstructionsClientPutOptions struct {
	// placeholder for future optional parameters
}

// Invoice - An invoice.
type Invoice struct {
	// An invoice.
	Properties *InvoiceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InvoiceListResult - The list of invoices.
type InvoiceListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of invoices.
	Value []*Invoice `json:"value,omitempty" azure:"ro"`
}

// InvoiceProperties - The properties of the invoice.
type InvoiceProperties struct {
	// READ-ONLY; The amount due as of now.
	AmountDue *Amount `json:"amountDue,omitempty" azure:"ro"`

	// READ-ONLY; The amount of Azure prepayment applied to the charges. This field is applicable to billing accounts with agreement
	// type Microsoft Customer Agreement.
	AzurePrepaymentApplied *Amount `json:"azurePrepaymentApplied,omitempty" azure:"ro"`

	// READ-ONLY; The total charges for the invoice billing period.
	BilledAmount *Amount `json:"billedAmount,omitempty" azure:"ro"`

	// READ-ONLY; The Id of the active invoice which is originally billed after this invoice was voided. This field is applicable
	// to the void invoices only.
	BilledDocumentID *string `json:"billedDocumentId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the billing profile for which the invoice is generated.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile for which the invoice is generated.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; The total refund for returns and cancellations during the invoice billing period. This field is applicable to
	// billing accounts with agreement type Microsoft Customer Agreement.
	CreditAmount *Amount `json:"creditAmount,omitempty" azure:"ro"`

	// READ-ONLY; The Id of the invoice which got voided and this credit note was issued as a result. This field is applicable
	// to the credit notes only.
	CreditForDocumentID *string `json:"creditForDocumentId,omitempty" azure:"ro"`

	// READ-ONLY; The type of the document.
	DocumentType *InvoiceDocumentType `json:"documentType,omitempty" azure:"ro"`

	// READ-ONLY; List of documents available to download such as invoice and tax receipt.
	Documents []*Document `json:"documents,omitempty" azure:"ro"`

	// READ-ONLY; The due date for the invoice.
	DueDate *time.Time `json:"dueDate,omitempty" azure:"ro"`

	// READ-ONLY; The amount of free Azure credits applied to the charges. This field is applicable to billing accounts with agreement
	// type Microsoft Customer Agreement.
	FreeAzureCreditApplied *Amount `json:"freeAzureCreditApplied,omitempty" azure:"ro"`

	// READ-ONLY; The date when the invoice was generated.
	InvoiceDate *time.Time `json:"invoiceDate,omitempty" azure:"ro"`

	// READ-ONLY; The end date of the billing period for which the invoice is generated.
	InvoicePeriodEndDate *time.Time `json:"invoicePeriodEndDate,omitempty" azure:"ro"`

	// READ-ONLY; The start date of the billing period for which the invoice is generated.
	InvoicePeriodStartDate *time.Time `json:"invoicePeriodStartDate,omitempty" azure:"ro"`

	// READ-ONLY; Invoice type.
	InvoiceType *InvoiceType `json:"invoiceType,omitempty" azure:"ro"`

	// READ-ONLY; Specifies if the invoice is generated as part of monthly invoicing cycle or not. This field is applicable to
	// billing accounts with agreement type Microsoft Customer Agreement.
	IsMonthlyInvoice *bool `json:"isMonthlyInvoice,omitempty" azure:"ro"`

	// READ-ONLY; List of payments.
	Payments []*PaymentProperties `json:"payments,omitempty" azure:"ro"`

	// READ-ONLY; An optional purchase order number for the invoice.
	PurchaseOrderNumber *string `json:"purchaseOrderNumber,omitempty" azure:"ro"`

	// READ-ONLY; Rebill details for an invoice.
	RebillDetails map[string]*RebillDetails `json:"rebillDetails,omitempty" azure:"ro"`

	// READ-ONLY; The current status of the invoice.
	Status *InvoiceStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The pre-tax amount due. This field is applicable to billing accounts with agreement type Microsoft Customer
	// Agreement.
	SubTotal *Amount `json:"subTotal,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the subscription for which the invoice is generated.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; The amount of tax charged for the billing period. This field is applicable to billing accounts with agreement
	// type Microsoft Customer Agreement.
	TaxAmount *Amount `json:"taxAmount,omitempty" azure:"ro"`

	// READ-ONLY; The amount due when the invoice was generated. This field is applicable to billing accounts with agreement type
	// Microsoft Customer Agreement.
	TotalAmount *Amount `json:"totalAmount,omitempty" azure:"ro"`
}

// InvoiceSection - An invoice section.
type InvoiceSection struct {
	// The properties of an invoice section.
	Properties *InvoiceSectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InvoiceSectionCreationRequest - The properties of the invoice section.
type InvoiceSectionCreationRequest struct {
	// The name of the invoice section.
	DisplayName *string `json:"displayName,omitempty"`
}

// InvoiceSectionListResult - The list of invoice sections.
type InvoiceSectionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of invoice sections.
	Value []*InvoiceSection `json:"value,omitempty" azure:"ro"`
}

// InvoiceSectionListWithCreateSubPermissionResult - The list of invoice section properties with create subscription permission.
type InvoiceSectionListWithCreateSubPermissionResult struct {
	// The list of invoice section properties with create subscription permission.
	Value []*InvoiceSectionWithCreateSubPermission `json:"value,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InvoiceSectionProperties - The properties of an invoice section.
type InvoiceSectionProperties struct {
	// The name of the invoice section.
	DisplayName *string `json:"displayName,omitempty"`

	// Dictionary of metadata associated with the invoice section.
	Labels map[string]*string `json:"labels,omitempty"`

	// Dictionary of metadata associated with the invoice section. Maximum key/value length supported of 256 characters. Keys/value
	// should not empty value nor null. Keys can not contain < > % & \ ? /
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Identifies the state of an invoice section.
	State *InvoiceSectionState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The system generated unique identifier for an invoice section.
	SystemID *string `json:"systemId,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the cloud environments that are associated with an invoice section. This is a system managed optional
	// field and gets updated as the invoice section gets associated with accounts in various
	// clouds.
	TargetCloud *TargetCloud `json:"targetCloud,omitempty" azure:"ro"`
}

// InvoiceSectionWithCreateSubPermission - Invoice section properties with create subscription permission.
type InvoiceSectionWithCreateSubPermission struct {
	// Enabled azure plans for the associated billing profile.
	EnabledAzurePlans []*AzurePlan `json:"enabledAzurePlans,omitempty"`

	// READ-ONLY; The name of the billing profile for the invoice section.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile for the invoice section.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; The billing profile spending limit.
	BillingProfileSpendingLimit *SpendingLimitForBillingProfile `json:"billingProfileSpendingLimit,omitempty" azure:"ro"`

	// READ-ONLY; The status of the billing profile.
	BillingProfileStatus *BillingProfileStatus `json:"billingProfileStatus,omitempty" azure:"ro"`

	// READ-ONLY; Reason for the specified billing profile status.
	BillingProfileStatusReasonCode *StatusReasonCodeForBillingProfile `json:"billingProfileStatusReasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The system generated unique identifier for a billing profile.
	BillingProfileSystemID *string `json:"billingProfileSystemId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the invoice section.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the invoice section.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; The system generated unique identifier for an invoice section.
	InvoiceSectionSystemID *string `json:"invoiceSectionSystemId,omitempty" azure:"ro"`
}

// InvoiceSectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the InvoiceSectionsClient.BeginCreateOrUpdate
// method.
type InvoiceSectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InvoiceSectionsClientGetOptions contains the optional parameters for the InvoiceSectionsClient.Get method.
type InvoiceSectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InvoiceSectionsClientListByBillingProfileOptions contains the optional parameters for the InvoiceSectionsClient.ListByBillingProfile
// method.
type InvoiceSectionsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// InvoiceSectionsOnExpand - The invoice sections associated to the billing profile. By default this is not populated, unless
// it's specified in $expand.
type InvoiceSectionsOnExpand struct {
	// The invoice sections associated to the billing profile.
	Value []*InvoiceSection `json:"value,omitempty"`

	// READ-ONLY; Indicates whether there are more invoice sections than the ones listed in this collection. The collection lists
	// a maximum of 50 invoice sections. To get all invoice sections, use the list invoice
	// sections API.
	HasMoreResults *bool `json:"hasMoreResults,omitempty" azure:"ro"`
}

// InvoicesClientBeginDownloadBillingSubscriptionInvoiceOptions contains the optional parameters for the InvoicesClient.BeginDownloadBillingSubscriptionInvoice
// method.
type InvoicesClientBeginDownloadBillingSubscriptionInvoiceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InvoicesClientBeginDownloadInvoiceOptions contains the optional parameters for the InvoicesClient.BeginDownloadInvoice
// method.
type InvoicesClientBeginDownloadInvoiceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InvoicesClientBeginDownloadMultipleBillingProfileInvoicesOptions contains the optional parameters for the InvoicesClient.BeginDownloadMultipleBillingProfileInvoices
// method.
type InvoicesClientBeginDownloadMultipleBillingProfileInvoicesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InvoicesClientBeginDownloadMultipleBillingSubscriptionInvoicesOptions contains the optional parameters for the InvoicesClient.BeginDownloadMultipleBillingSubscriptionInvoices
// method.
type InvoicesClientBeginDownloadMultipleBillingSubscriptionInvoicesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InvoicesClientGetByIDOptions contains the optional parameters for the InvoicesClient.GetByID method.
type InvoicesClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// InvoicesClientGetBySubscriptionAndInvoiceIDOptions contains the optional parameters for the InvoicesClient.GetBySubscriptionAndInvoiceID
// method.
type InvoicesClientGetBySubscriptionAndInvoiceIDOptions struct {
	// placeholder for future optional parameters
}

// InvoicesClientGetOptions contains the optional parameters for the InvoicesClient.Get method.
type InvoicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// InvoicesClientListByBillingAccountOptions contains the optional parameters for the InvoicesClient.ListByBillingAccount
// method.
type InvoicesClientListByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// InvoicesClientListByBillingProfileOptions contains the optional parameters for the InvoicesClient.ListByBillingProfile
// method.
type InvoicesClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// InvoicesClientListByBillingSubscriptionOptions contains the optional parameters for the InvoicesClient.ListByBillingSubscription
// method.
type InvoicesClientListByBillingSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// Operation - A Billing REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Identifies if the operation is a data operation.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation type such as read, write and delete.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.Billing.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed such as invoice and billing subscription.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - The list of billing operations and a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing operations supported by the Microsoft.Billing resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsErrorDetails - The details of the error.
type OperationsErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// OperationsErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason
// is provided in the error message.
type OperationsErrorResponse struct {
	// The details of the error.
	Error *OperationsErrorDetails `json:"error,omitempty"`
}

// Participants - The details about a participant.
type Participants struct {
	// READ-ONLY; The email address of the participant.
	Email *string `json:"email,omitempty" azure:"ro"`

	// READ-ONLY; The acceptance status of the participant.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The date when the status got changed.
	StatusDate *time.Time `json:"statusDate,omitempty" azure:"ro"`
}

// PaymentProperties - The properties of a payment.
type PaymentProperties struct {
	// The family of payment method.
	PaymentMethodFamily *PaymentMethodFamily `json:"paymentMethodFamily,omitempty"`

	// READ-ONLY; The paid amount.
	Amount *Amount `json:"amount,omitempty" azure:"ro"`

	// READ-ONLY; The date when the payment was made.
	Date *time.Time `json:"date,omitempty" azure:"ro"`

	// READ-ONLY; The type of payment method.
	PaymentMethodType *string `json:"paymentMethodType,omitempty" azure:"ro"`

	// READ-ONLY; The type of payment.
	PaymentType *string `json:"paymentType,omitempty" azure:"ro"`
}

// Period - A billing period resource.
type Period struct {
	// A billing period.
	Properties *PeriodProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PeriodProperties - The properties of the billing period.
type PeriodProperties struct {
	// READ-ONLY; The end of the date range covered by the billing period.
	BillingPeriodEndDate *time.Time `json:"billingPeriodEndDate,omitempty" azure:"ro"`

	// READ-ONLY; The start of the date range covered by the billing period.
	BillingPeriodStartDate *time.Time `json:"billingPeriodStartDate,omitempty" azure:"ro"`

	// READ-ONLY; Array of invoice ids that associated with.
	InvoiceIDs []*string `json:"invoiceIds,omitempty" azure:"ro"`
}

// PeriodsClientGetOptions contains the optional parameters for the PeriodsClient.Get method.
type PeriodsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PeriodsClientListOptions contains the optional parameters for the PeriodsClient.List method.
type PeriodsClientListOptions struct {
	// May be used to filter billing periods by billingPeriodEndDate. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'.
	// It does not currently support 'ne', 'or', or 'not'.
	Filter *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the most recent N billing periods.
	Top *int32
}

// PeriodsListResult - Result of listing billing periods. It contains a list of available billing periods in reverse chronological
// order.
type PeriodsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing periods.
	Value []*Period `json:"value,omitempty" azure:"ro"`
}

// PermissionsClientListByBillingAccountOptions contains the optional parameters for the PermissionsClient.ListByBillingAccount
// method.
type PermissionsClientListByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// PermissionsClientListByBillingProfileOptions contains the optional parameters for the PermissionsClient.ListByBillingProfile
// method.
type PermissionsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// PermissionsClientListByCustomerOptions contains the optional parameters for the PermissionsClient.ListByCustomer method.
type PermissionsClientListByCustomerOptions struct {
	// placeholder for future optional parameters
}

// PermissionsClientListByInvoiceSectionsOptions contains the optional parameters for the PermissionsClient.ListByInvoiceSections
// method.
type PermissionsClientListByInvoiceSectionsOptions struct {
	// placeholder for future optional parameters
}

// PermissionsListResult - Result of list billingPermissions a caller has on a billing account.
type PermissionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of billingPermissions a caller has on a billing account.
	Value []*PermissionsProperties `json:"value,omitempty" azure:"ro"`
}

// PermissionsProperties - The set of allowed action and not allowed actions a caller has on a billing account
type PermissionsProperties struct {
	// READ-ONLY; The set of actions that the caller is allowed to perform.
	Actions []*string `json:"actions,omitempty" azure:"ro"`

	// READ-ONLY; The set of actions that the caller is not allowed to perform.
	NotActions []*string `json:"notActions,omitempty" azure:"ro"`
}

// PoliciesClientGetByBillingProfileOptions contains the optional parameters for the PoliciesClient.GetByBillingProfile method.
type PoliciesClientGetByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientGetByCustomerOptions contains the optional parameters for the PoliciesClient.GetByCustomer method.
type PoliciesClientGetByCustomerOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientUpdateCustomerOptions contains the optional parameters for the PoliciesClient.UpdateCustomer method.
type PoliciesClientUpdateCustomerOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientUpdateOptions contains the optional parameters for the PoliciesClient.Update method.
type PoliciesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Policy - A policy.
type Policy struct {
	// The properties of a policy.
	Properties *PolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicyProperties - The properties of a policy.
type PolicyProperties struct {
	// The policy that controls whether Azure marketplace purchases are allowed for a billing profile.
	MarketplacePurchases *MarketplacePurchasesPolicy `json:"marketplacePurchases,omitempty"`

	// The policy that controls whether Azure reservation purchases are allowed for a billing profile.
	ReservationPurchases *ReservationPurchasesPolicy `json:"reservationPurchases,omitempty"`

	// The policy that controls whether users with Azure RBAC access to a subscription can view its charges.
	ViewCharges *ViewChargesPolicy `json:"viewCharges,omitempty"`
}

// Product - A product.
type Product struct {
	// The properties of a product.
	Properties *ProductProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProductProperties - The properties of a product.
type ProductProperties struct {
	// Indicates whether auto renewal is turned on or off for a product.
	AutoRenew *AutoRenew `json:"autoRenew,omitempty"`

	// The frequency at which the product will be billed.
	BillingFrequency *BillingFrequency `json:"billingFrequency,omitempty"`

	// The current status of the product.
	Status *ProductStatusType `json:"status,omitempty"`

	// READ-ONLY; The availability of the product.
	AvailabilityID *string `json:"availabilityId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the billing profile to which the product is billed.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile to which the product is billed.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerID *string `json:"customerId,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the product.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The date when the product will be renewed or canceled.
	EndDate *time.Time `json:"endDate,omitempty" azure:"ro"`

	// READ-ONLY; The name of the invoice section to which the product is billed.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the invoice section to which the product is billed.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; The last month charges.
	LastCharge *Amount `json:"lastCharge,omitempty" azure:"ro"`

	// READ-ONLY; The date of the last charge.
	LastChargeDate *time.Time `json:"lastChargeDate,omitempty" azure:"ro"`

	// READ-ONLY; The description of the type of product.
	ProductType *string `json:"productType,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the type of product.
	ProductTypeID *string `json:"productTypeId,omitempty" azure:"ro"`

	// READ-ONLY; The date when the product was purchased.
	PurchaseDate *time.Time `json:"purchaseDate,omitempty" azure:"ro"`

	// READ-ONLY; The quantity purchased for the product.
	Quantity *float32 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; Reseller for this product.
	Reseller *Reseller `json:"reseller,omitempty" azure:"ro"`

	// READ-ONLY; The sku description of the product.
	SKUDescription *string `json:"skuDescription,omitempty" azure:"ro"`

	// READ-ONLY; The sku ID of the product.
	SKUID *string `json:"skuId,omitempty" azure:"ro"`

	// READ-ONLY; The id of the tenant in which the product is used.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ProductsClientGetOptions contains the optional parameters for the ProductsClient.Get method.
type ProductsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ProductsClientListByBillingAccountOptions contains the optional parameters for the ProductsClient.ListByBillingAccount
// method.
type ProductsClientListByBillingAccountOptions struct {
	// May be used to filter by product type. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently
	// support 'ne', 'or', or 'not'. Tag filter is a key value pair string where key
	// and value are separated by a colon (:).
	Filter *string
}

// ProductsClientListByBillingProfileOptions contains the optional parameters for the ProductsClient.ListByBillingProfile
// method.
type ProductsClientListByBillingProfileOptions struct {
	// May be used to filter by product type. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently
	// support 'ne', 'or', or 'not'. Tag filter is a key value pair string where key
	// and value are separated by a colon (:).
	Filter *string
}

// ProductsClientListByCustomerOptions contains the optional parameters for the ProductsClient.ListByCustomer method.
type ProductsClientListByCustomerOptions struct {
	// placeholder for future optional parameters
}

// ProductsClientListByInvoiceSectionOptions contains the optional parameters for the ProductsClient.ListByInvoiceSection
// method.
type ProductsClientListByInvoiceSectionOptions struct {
	// May be used to filter by product type. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently
	// support 'ne', 'or', or 'not'. Tag filter is a key value pair string where key
	// and value are separated by a colon (:).
	Filter *string
}

// ProductsClientMoveOptions contains the optional parameters for the ProductsClient.Move method.
type ProductsClientMoveOptions struct {
	// placeholder for future optional parameters
}

// ProductsClientUpdateOptions contains the optional parameters for the ProductsClient.Update method.
type ProductsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProductsClientValidateMoveOptions contains the optional parameters for the ProductsClient.ValidateMove method.
type ProductsClientValidateMoveOptions struct {
	// placeholder for future optional parameters
}

// ProductsListResult - The list of products. It contains a list of available product summaries in reverse chronological order
// by purchase date.
type ProductsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of products.
	Value []*Product `json:"value,omitempty" azure:"ro"`
}

// Profile - A billing profile.
type Profile struct {
	// The properties of the billing profile.
	Properties *ProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProfileCreationRequest - The request parameters for creating a new billing profile.
type ProfileCreationRequest struct {
	// The address of the individual or organization that is responsible for the billing profile.
	BillTo *AddressDetails `json:"billTo,omitempty"`

	// The name of the billing profile.
	DisplayName *string `json:"displayName,omitempty"`

	// Enabled azure plans for the billing profile.
	EnabledAzurePlans []*AzurePlan `json:"enabledAzurePlans,omitempty"`

	// Flag controlling whether the invoices for the billing profile are sent through email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`

	// The purchase order name that will appear on the invoices generated for the billing profile.
	PoNumber *string `json:"poNumber,omitempty"`
}

// ProfileInfo - Details about billing profile associated with agreement and available only for specific agreements.
type ProfileInfo struct {
	// The name of the billing profile
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`

	// The unique identifier for the billing profile.
	BillingProfileID *string `json:"billingProfileId,omitempty"`

	// Billing account name. This property is available for a specific type of agreement.
	IndirectRelationshipOrganizationName *string `json:"indirectRelationshipOrganizationName,omitempty"`
}

// ProfileListResult - The list of billing profiles.
type ProfileListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing profiles.
	Value []*Profile `json:"value,omitempty" azure:"ro"`
}

// ProfileProperties - The properties of the billing profile.
type ProfileProperties struct {
	// Billing address.
	BillTo *AddressDetails `json:"billTo,omitempty"`

	// The name of the billing profile.
	DisplayName *string `json:"displayName,omitempty"`

	// Information about the enabled azure plans.
	EnabledAzurePlans []*AzurePlan `json:"enabledAzurePlans,omitempty"`

	// Flag controlling whether the invoices for the billing profile are sent through email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`

	// The invoice sections associated to the billing profile. By default this is not populated, unless it's specified in $expand.
	InvoiceSections *InvoiceSectionsOnExpand `json:"invoiceSections,omitempty"`

	// The purchase order name that will appear on the invoices generated for the billing profile.
	PoNumber *string `json:"poNumber,omitempty"`

	// Tags of billing profiles.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Identifies which services and purchases are paid by a billing profile.
	BillingRelationshipType *BillingRelationshipType `json:"billingRelationshipType,omitempty" azure:"ro"`

	// READ-ONLY; The currency in which the charges for the billing profile are billed.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether user has read access to the billing profile.
	HasReadAccess *bool `json:"hasReadAccess,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the billing profile that is linked to another billing profile in indirect purchase motion.
	IndirectRelationshipInfo *IndirectRelationshipInfo `json:"indirectRelationshipInfo,omitempty" azure:"ro"`

	// READ-ONLY; The day of the month when the invoice for the billing profile is generated.
	InvoiceDay *int32 `json:"invoiceDay,omitempty" azure:"ro"`

	// READ-ONLY; The billing profile spending limit.
	SpendingLimit *SpendingLimit `json:"spendingLimit,omitempty" azure:"ro"`

	// READ-ONLY; The status of the billing profile.
	Status *BillingProfileStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Reason for the specified billing profile status.
	StatusReasonCode *StatusReasonCode `json:"statusReasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The system generated unique identifier for a billing profile.
	SystemID *string `json:"systemId,omitempty" azure:"ro"`

	// READ-ONLY; Identifies the cloud environments that are associated with a billing profile. This is a system managed optional
	// field and gets updated as the billing profile gets associated with accounts in various
	// clouds.
	TargetClouds []*TargetCloud `json:"targetClouds,omitempty" azure:"ro"`
}

// ProfilesClientBeginCreateOrUpdateOptions contains the optional parameters for the ProfilesClient.BeginCreateOrUpdate method.
type ProfilesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientGetOptions contains the optional parameters for the ProfilesClient.Get method.
type ProfilesClientGetOptions struct {
	// May be used to expand the invoice sections.
	Expand *string
}

// ProfilesClientListByBillingAccountOptions contains the optional parameters for the ProfilesClient.ListByBillingAccount
// method.
type ProfilesClientListByBillingAccountOptions struct {
	// May be used to expand the invoice sections.
	Expand *string
}

// ProfilesOnExpand - The billing profiles associated with the billing account. By default this is not populated, unless it's
// specified in $expand.
type ProfilesOnExpand struct {
	// The billing profiles associated with the billing account.
	Value []*Profile `json:"value,omitempty"`

	// READ-ONLY; Indicates whether there are more billing profiles than the ones listed in this collection. The collection lists
	// a maximum of 50 billing profiles. To get all billing profiles, use the list billing
	// profiles API.
	HasMoreResults *bool `json:"hasMoreResults,omitempty" azure:"ro"`
}

// Property - A billing property.
type Property struct {
	// A billing property.
	Properties *PropertyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PropertyClientGetOptions contains the optional parameters for the PropertyClient.Get method.
type PropertyClientGetOptions struct {
	// placeholder for future optional parameters
}

// PropertyClientUpdateOptions contains the optional parameters for the PropertyClient.Update method.
type PropertyClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PropertyProperties - The billing property.
type PropertyProperties struct {
	// The cost center applied to the subscription.
	CostCenter *string `json:"costCenter,omitempty"`

	// READ-ONLY; The email address on which the account admin gets all Azure notifications.
	AccountAdminNotificationEmailAddress *string `json:"accountAdminNotificationEmailAddress,omitempty" azure:"ro"`

	// READ-ONLY; The name of the billing account to which the subscription is billed.
	BillingAccountDisplayName *string `json:"billingAccountDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing account to which the subscription is billed.
	BillingAccountID *string `json:"billingAccountId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the billing profile to which the subscription is billed.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile to which the subscription is billed.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; The billing profile spending limit.
	BillingProfileSpendingLimit *BillingProfileSpendingLimit `json:"billingProfileSpendingLimit,omitempty" azure:"ro"`

	// READ-ONLY; The status of the billing profile.
	BillingProfileStatus *BillingProfileStatus `json:"billingProfileStatus,omitempty" azure:"ro"`

	// READ-ONLY; Reason for the specified billing profile status.
	BillingProfileStatusReasonCode *BillingProfileStatusReasonCode `json:"billingProfileStatusReasonCode,omitempty" azure:"ro"`

	// READ-ONLY; The Azure AD tenant ID of the billing account for the subscription.
	BillingTenantID *string `json:"billingTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the invoice section to which the subscription is billed.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the invoice section to which the subscription is billed.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether user is the account admin.
	IsAccountAdmin *bool `json:"isAccountAdmin,omitempty" azure:"ro"`

	// READ-ONLY; The product ID of the Azure plan.
	ProductID *string `json:"productId,omitempty" azure:"ro"`

	// READ-ONLY; The product name of the Azure plan.
	ProductName *string `json:"productName,omitempty" azure:"ro"`

	// READ-ONLY; The sku description of the Azure plan for the subscription.
	SKUDescription *string `json:"skuDescription,omitempty" azure:"ro"`

	// READ-ONLY; The sku ID of the Azure plan for the subscription.
	SKUID *string `json:"skuId,omitempty" azure:"ro"`
}

// RebillDetails - The rebill details of an invoice.
type RebillDetails struct {
	// READ-ONLY; The ID of credit note.
	CreditNoteDocumentID *string `json:"creditNoteDocumentId,omitempty" azure:"ro"`

	// READ-ONLY; The ID of invoice.
	InvoiceDocumentID *string `json:"invoiceDocumentId,omitempty" azure:"ro"`

	// READ-ONLY; Rebill details for an invoice.
	RebillDetails map[string]*RebillDetails `json:"rebillDetails,omitempty" azure:"ro"`
}

// Reseller - Details of the reseller.
type Reseller struct {
	// READ-ONLY; The name of the reseller.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The MPN ID of the reseller.
	ResellerID *string `json:"resellerId,omitempty" azure:"ro"`
}

// Reservation - The definition of the reservation.
type Reservation struct {
	// The properties associated to this reservation
	Properties *ReservationProperty `json:"properties,omitempty"`

	// The sku information associated to this reservation
	SKU *ReservationSKUProperty `json:"sku,omitempty"`

	// READ-ONLY; The id of the reservation.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The location of the reservation.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The name of the reservation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the reservation.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReservationProperty - The property of reservation object.
type ReservationProperty struct {
	// The array of applied scopes of a reservation. Will be null if the reservation is in Shared scope
	AppliedScopes []*string `json:"appliedScopes,omitempty"`

	// READ-ONLY; The applied scope type of the reservation.
	AppliedScopeType *string `json:"appliedScopeType,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the reservation
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the reservation for display, e.g. Succeeded
	DisplayProvisioningState *string `json:"displayProvisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The effective date time of the reservation
	EffectiveDateTime *string `json:"effectiveDateTime,omitempty" azure:"ro"`

	// READ-ONLY; The expiry date of the reservation
	ExpiryDate *string `json:"expiryDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the reservation, e.g. Succeeded
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the reservation, e.g. Succeeded
	ProvisioningSubState *string `json:"provisioningSubState,omitempty" azure:"ro"`

	// READ-ONLY; The number of the reservation.
	Quantity *float32 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; The renew state of the reservation
	Renew *bool `json:"renew,omitempty" azure:"ro"`

	// READ-ONLY; The renew source of the reservation
	RenewSource *string `json:"renewSource,omitempty" azure:"ro"`

	// READ-ONLY; The reserved source type of the reservation, e.g. virtual machine.
	ReservedResourceType *string `json:"reservedResourceType,omitempty" azure:"ro"`

	// READ-ONLY; The sku description of the reservation
	SKUDescription *string `json:"skuDescription,omitempty" azure:"ro"`

	// READ-ONLY; The term of the reservation, e.g. P1Y
	Term *string `json:"term,omitempty" azure:"ro"`

	// READ-ONLY; The applied scope type of the reservation for display, e.g. Shared
	UserFriendlyAppliedScopeType *string `json:"userFriendlyAppliedScopeType,omitempty" azure:"ro"`

	// READ-ONLY; The renew state of the reservation for display, e.g. On
	UserFriendlyRenewState *string `json:"userFriendlyRenewState,omitempty" azure:"ro"`

	// READ-ONLY; Reservation utilization
	Utilization *ReservationPropertyUtilization `json:"utilization,omitempty" azure:"ro"`
}

// ReservationPropertyUtilization - Reservation utilization
type ReservationPropertyUtilization struct {
	// The array of aggregates of a reservation's utilization
	Aggregates []*ReservationUtilizationAggregates `json:"aggregates,omitempty"`

	// READ-ONLY; The number of days trend for a reservation
	Trend *string `json:"trend,omitempty" azure:"ro"`
}

// ReservationSKUProperty - The property of reservation sku object.
type ReservationSKUProperty struct {
	// READ-ONLY; The name of the reservation sku.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// ReservationSummary - The roll up count summary of reservations in each state
type ReservationSummary struct {
	// READ-ONLY; The number of reservation in Cancelled state
	CancelledCount *float32 `json:"cancelledCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Expired state
	ExpiredCount *float32 `json:"expiredCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Expiring state
	ExpiringCount *float32 `json:"expiringCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Failed state
	FailedCount *float32 `json:"failedCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Pending state
	PendingCount *float32 `json:"pendingCount,omitempty" azure:"ro"`

	// READ-ONLY; The number of reservation in Succeeded state
	SucceededCount *float32 `json:"succeededCount,omitempty" azure:"ro"`
}

// ReservationUtilizationAggregates - The aggregate values of reservation utilization
type ReservationUtilizationAggregates struct {
	// READ-ONLY; The grain of the aggregate
	Grain *float32 `json:"grain,omitempty" azure:"ro"`

	// READ-ONLY; The grain unit of the aggregate
	GrainUnit *string `json:"grainUnit,omitempty" azure:"ro"`

	// READ-ONLY; The aggregate value
	Value *float32 `json:"value,omitempty" azure:"ro"`

	// READ-ONLY; The aggregate value unit
	ValueUnit *string `json:"valueUnit,omitempty" azure:"ro"`
}

// ReservationsClientListByBillingAccountOptions contains the optional parameters for the ReservationsClient.ListByBillingAccount
// method.
type ReservationsClientListByBillingAccountOptions struct {
	// May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support
	// 'ne', 'gt', 'le', 'ge', or 'not'.
	Filter *string
	// May be used to sort order by reservation properties.
	Orderby *string
	// To indicate whether to refresh the roll up counts of the reservations group by provisioning states
	RefreshSummary *string
	// The selected provisioning state
	SelectedState *string
}

// ReservationsClientListByBillingProfileOptions contains the optional parameters for the ReservationsClient.ListByBillingProfile
// method.
type ReservationsClientListByBillingProfileOptions struct {
	// May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support
	// 'ne', 'gt', 'le', 'ge', or 'not'.
	Filter *string
	// May be used to sort order by reservation properties.
	Orderby *string
	// To indicate whether to refresh the roll up counts of the reservations group by provisioning state
	RefreshSummary *string
	// The selected provisioning state
	SelectedState *string
}

// ReservationsListResult - The list of reservations and summary of roll out count of reservations in each state.
type ReservationsListResult struct {
	// The roll out count summary of the reservations
	Summary *ReservationSummary `json:"summary,omitempty"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of reservations.
	Value []*Reservation `json:"value,omitempty" azure:"ro"`
}

// Resource - The Resource model definition.
type Resource struct {
	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleAssignment - The role assignment
type RoleAssignment struct {
	// The properties of the role assignment.
	Properties *RoleAssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleAssignmentListResult - The list of role assignments.
type RoleAssignmentListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of role assignments.
	Value []*RoleAssignment `json:"value,omitempty" azure:"ro"`
}

// RoleAssignmentProperties - The properties of the role assignment.
type RoleAssignmentProperties struct {
	// The principal id of the user to whom the role was assigned.
	PrincipalID *string `json:"principalId,omitempty"`

	// The principal tenant id of the user to whom the role was assigned.
	PrincipalTenantID *string `json:"principalTenantId,omitempty"`

	// The ID of the role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`

	// The authentication type.
	UserAuthenticationType *string `json:"userAuthenticationType,omitempty"`

	// The email address of the user.
	UserEmailAddress *string `json:"userEmailAddress,omitempty"`

	// READ-ONLY; The principal Id of the user who created the role assignment.
	CreatedByPrincipalID *string `json:"createdByPrincipalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant Id of the user who created the role assignment.
	CreatedByPrincipalTenantID *string `json:"createdByPrincipalTenantId,omitempty" azure:"ro"`

	// READ-ONLY; The email address of the user who created the role assignment.
	CreatedByUserEmailAddress *string `json:"createdByUserEmailAddress,omitempty" azure:"ro"`

	// READ-ONLY; The date the role assignment was created.
	CreatedOn *string `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; The scope at which the role was assigned.
	Scope *string `json:"scope,omitempty" azure:"ro"`
}

// RoleAssignmentsClientDeleteByBillingAccountOptions contains the optional parameters for the RoleAssignmentsClient.DeleteByBillingAccount
// method.
type RoleAssignmentsClientDeleteByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientDeleteByBillingProfileOptions contains the optional parameters for the RoleAssignmentsClient.DeleteByBillingProfile
// method.
type RoleAssignmentsClientDeleteByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientDeleteByInvoiceSectionOptions contains the optional parameters for the RoleAssignmentsClient.DeleteByInvoiceSection
// method.
type RoleAssignmentsClientDeleteByInvoiceSectionOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientGetByBillingAccountOptions contains the optional parameters for the RoleAssignmentsClient.GetByBillingAccount
// method.
type RoleAssignmentsClientGetByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientGetByBillingProfileOptions contains the optional parameters for the RoleAssignmentsClient.GetByBillingProfile
// method.
type RoleAssignmentsClientGetByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientGetByInvoiceSectionOptions contains the optional parameters for the RoleAssignmentsClient.GetByInvoiceSection
// method.
type RoleAssignmentsClientGetByInvoiceSectionOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientListByBillingAccountOptions contains the optional parameters for the RoleAssignmentsClient.ListByBillingAccount
// method.
type RoleAssignmentsClientListByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientListByBillingProfileOptions contains the optional parameters for the RoleAssignmentsClient.ListByBillingProfile
// method.
type RoleAssignmentsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientListByInvoiceSectionOptions contains the optional parameters for the RoleAssignmentsClient.ListByInvoiceSection
// method.
type RoleAssignmentsClientListByInvoiceSectionOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinition - The properties of a role definition.
type RoleDefinition struct {
	// The properties of the a role definition.
	Properties *RoleDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleDefinitionListResult - The list of role definitions.
type RoleDefinitionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The role definitions.
	Value []*RoleDefinition `json:"value,omitempty" azure:"ro"`
}

// RoleDefinitionProperties - The properties of the a role definition.
type RoleDefinitionProperties struct {
	// The billingPermissions the role has
	Permissions []*PermissionsProperties `json:"permissions,omitempty"`

	// READ-ONLY; The role description
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The name of the role
	RoleName *string `json:"roleName,omitempty" azure:"ro"`
}

// RoleDefinitionsClientGetByBillingAccountOptions contains the optional parameters for the RoleDefinitionsClient.GetByBillingAccount
// method.
type RoleDefinitionsClientGetByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientGetByBillingProfileOptions contains the optional parameters for the RoleDefinitionsClient.GetByBillingProfile
// method.
type RoleDefinitionsClientGetByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientGetByInvoiceSectionOptions contains the optional parameters for the RoleDefinitionsClient.GetByInvoiceSection
// method.
type RoleDefinitionsClientGetByInvoiceSectionOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientListByBillingAccountOptions contains the optional parameters for the RoleDefinitionsClient.ListByBillingAccount
// method.
type RoleDefinitionsClientListByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientListByBillingProfileOptions contains the optional parameters for the RoleDefinitionsClient.ListByBillingProfile
// method.
type RoleDefinitionsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientListByInvoiceSectionOptions contains the optional parameters for the RoleDefinitionsClient.ListByInvoiceSection
// method.
type RoleDefinitionsClientListByInvoiceSectionOptions struct {
	// placeholder for future optional parameters
}

// Subscription - A billing subscription.
type Subscription struct {
	// The billing properties of a subscription.
	Properties *SubscriptionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubscriptionProperties - The billing properties of a subscription.
type SubscriptionProperties struct {
	// The cost center applied to the subscription.
	CostCenter *string `json:"costCenter,omitempty"`

	// The sku ID of the Azure plan for the subscription.
	SKUID *string `json:"skuId,omitempty"`

	// The current billing status of the subscription.
	SubscriptionBillingStatus *BillingSubscriptionStatusType `json:"subscriptionBillingStatus,omitempty"`

	// READ-ONLY; The name of the billing profile to which the subscription is billed.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile to which the subscription is billed.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the customer for whom the subscription was created. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the customer for whom the subscription was created. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerID *string `json:"customerId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the subscription.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the invoice section to which the subscription is billed.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the invoice section to which the subscription is billed.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; The last month charges.
	LastMonthCharges *Amount `json:"lastMonthCharges,omitempty" azure:"ro"`

	// READ-ONLY; The current month to date charges.
	MonthToDateCharges *Amount `json:"monthToDateCharges,omitempty" azure:"ro"`

	// READ-ONLY; Reseller for this subscription.
	Reseller *Reseller `json:"reseller,omitempty" azure:"ro"`

	// READ-ONLY; The sku description of the Azure plan for the subscription.
	SKUDescription *string `json:"skuDescription,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the subscription.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; The suspension reason for a subscription. Applies only to subscriptions in Microsoft Online Services Program
	// billing accounts.
	SuspensionReasons []*string `json:"suspensionReasons,omitempty" azure:"ro"`
}

// SubscriptionsClientBeginMoveOptions contains the optional parameters for the SubscriptionsClient.BeginMove method.
type SubscriptionsClientBeginMoveOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubscriptionsClientGetOptions contains the optional parameters for the SubscriptionsClient.Get method.
type SubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListByBillingAccountOptions contains the optional parameters for the SubscriptionsClient.ListByBillingAccount
// method.
type SubscriptionsClientListByBillingAccountOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListByBillingProfileOptions contains the optional parameters for the SubscriptionsClient.ListByBillingProfile
// method.
type SubscriptionsClientListByBillingProfileOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListByCustomerOptions contains the optional parameters for the SubscriptionsClient.ListByCustomer method.
type SubscriptionsClientListByCustomerOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListByInvoiceSectionOptions contains the optional parameters for the SubscriptionsClient.ListByInvoiceSection
// method.
type SubscriptionsClientListByInvoiceSectionOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientUpdateOptions contains the optional parameters for the SubscriptionsClient.Update method.
type SubscriptionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientValidateMoveOptions contains the optional parameters for the SubscriptionsClient.ValidateMove method.
type SubscriptionsClientValidateMoveOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsListResult - The list of billing subscriptions.
type SubscriptionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of billing subscriptions.
	Value []*Subscription `json:"value,omitempty" azure:"ro"`
}

// Transaction - A transaction.
type Transaction struct {
	// The properties of a transaction.
	Properties *TransactionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransactionListResult - The list of transactions.
type TransactionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of records.
	TotalCount *int32 `json:"totalCount,omitempty" azure:"ro"`

	// READ-ONLY; The list of transactions.
	Value []*Transaction `json:"value,omitempty" azure:"ro"`
}

// TransactionProperties - The properties of a transaction.
type TransactionProperties struct {
	// The kind of transaction. Options are all or reservation.
	Kind *TransactionTypeKind `json:"kind,omitempty"`

	// The type of transaction.
	TransactionType *ReservationType `json:"transactionType,omitempty"`

	// READ-ONLY; The amount of any Azure credits automatically applied to this transaction.
	AzureCreditApplied *Amount `json:"azureCreditApplied,omitempty" azure:"ro"`

	// READ-ONLY; The type of azure plan of the subscription that was used for the transaction.
	AzurePlan *string `json:"azurePlan,omitempty" azure:"ro"`

	// READ-ONLY; The ISO 4217 code for the currency in which this transaction is billed.
	BillingCurrency *string `json:"billingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The name of the billing profile which will be billed for the transaction.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the billing profile which will be billed for the transaction.
	BillingProfileID *string `json:"billingProfileId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the customer for which the transaction took place. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the customer for which the transaction took place. The field is applicable only for Microsoft Partner
	// Agreement billing account.
	CustomerID *string `json:"customerId,omitempty" azure:"ro"`

	// READ-ONLY; The date of transaction.
	Date *time.Time `json:"date,omitempty" azure:"ro"`

	// READ-ONLY; The percentage discount, if any, applied to this transaction.
	Discount *float32 `json:"discount,omitempty" azure:"ro"`

	// READ-ONLY; The price of the product after applying any discounts.
	EffectivePrice *Amount `json:"effectivePrice,omitempty" azure:"ro"`

	// READ-ONLY; The exchange rate used to convert charged amount to billing currency, if applicable.
	ExchangeRate *float32 `json:"exchangeRate,omitempty" azure:"ro"`

	// READ-ONLY; Invoice on which the transaction was billed or 'pending' if the transaction is not billed.
	Invoice *string `json:"invoice,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the invoice on which the transaction was billed. This field is only applicable for transactions which
	// are billed.
	InvoiceID *string `json:"invoiceId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the invoice section which will be billed for the transaction.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the invoice section which will be billed for the transaction.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty" azure:"ro"`

	// READ-ONLY; The retail price of the product.
	MarketPrice *Amount `json:"marketPrice,omitempty" azure:"ro"`

	// READ-ONLY; The order ID of the reservation. The field is only applicable for transaction of kind reservation.
	OrderID *string `json:"orderId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the reservation order. The field is only applicable for transactions of kind reservation.
	OrderName *string `json:"orderName,omitempty" azure:"ro"`

	// READ-ONLY; The ISO 4217 code for the currency in which the product is priced.
	PricingCurrency *string `json:"pricingCurrency,omitempty" azure:"ro"`

	// READ-ONLY; The description of the product for which the transaction took place.
	ProductDescription *string `json:"productDescription,omitempty" azure:"ro"`

	// READ-ONLY; The family of the product for which the transaction took place.
	ProductFamily *string `json:"productFamily,omitempty" azure:"ro"`

	// READ-ONLY; The type of the product for which the transaction took place.
	ProductType *string `json:"productType,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the product type for which the transaction took place.
	ProductTypeID *string `json:"productTypeId,omitempty" azure:"ro"`

	// READ-ONLY; The quantity purchased in the transaction.
	Quantity *int32 `json:"quantity,omitempty" azure:"ro"`

	// READ-ONLY; The end date of the product term, or the end date of the month in which usage ended.
	ServicePeriodEndDate *time.Time `json:"servicePeriodEndDate,omitempty" azure:"ro"`

	// READ-ONLY; The date of the purchase of the product, or the start date of the month in which usage started.
	ServicePeriodStartDate *time.Time `json:"servicePeriodStartDate,omitempty" azure:"ro"`

	// READ-ONLY; The pre-tax charged amount for the transaction.
	SubTotal *Amount `json:"subTotal,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the subscription that was used for the transaction. The field is only applicable for transaction of
	// kind reservation.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`

	// READ-ONLY; The name of the subscription that was used for the transaction. The field is only applicable for transaction
	// of kind reservation.
	SubscriptionName *string `json:"subscriptionName,omitempty" azure:"ro"`

	// READ-ONLY; The tax amount applied to the transaction.
	Tax *Amount `json:"tax,omitempty" azure:"ro"`

	// READ-ONLY; The charge associated with the transaction.
	TransactionAmount *Amount `json:"transactionAmount,omitempty" azure:"ro"`

	// READ-ONLY; The unit of measure used to bill for the product. For example, compute services are billed per hour.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty" azure:"ro"`

	// READ-ONLY; The description for the unit of measure for a given product.
	UnitType *string `json:"unitType,omitempty" azure:"ro"`

	// READ-ONLY; The number of units used for a given product.
	Units *float32 `json:"units,omitempty" azure:"ro"`
}

// TransactionsClientListByInvoiceOptions contains the optional parameters for the TransactionsClient.ListByInvoice method.
type TransactionsClientListByInvoiceOptions struct {
	// placeholder for future optional parameters
}

// TransferBillingSubscriptionRequestProperties - Request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequestProperties struct {
	// REQUIRED; The destination invoice section id.
	DestinationInvoiceSectionID *string `json:"destinationInvoiceSectionId,omitempty"`
}

// TransferProductRequestProperties - The properties of the product to initiate a transfer.
type TransferProductRequestProperties struct {
	// The destination invoice section id.
	DestinationInvoiceSectionID *string `json:"destinationInvoiceSectionId,omitempty"`
}

// ValidateAddressResponse - Result of the address validation
type ValidateAddressResponse struct {
	// status of the address validation.
	Status *AddressValidationStatus `json:"status,omitempty"`

	// The list of suggested addresses.
	SuggestedAddresses []*AddressDetails `json:"suggestedAddresses,omitempty"`

	// Validation error message.
	ValidationMessage *string `json:"validationMessage,omitempty"`
}

// ValidateProductTransferEligibilityError - Error details of the product transfer eligibility validation.
type ValidateProductTransferEligibilityError struct {
	// Error code for the product transfer validation.
	Code *ProductTransferValidationErrorCode `json:"code,omitempty"`

	// Detailed error message explaining the error.
	Details *string `json:"details,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`
}

// ValidateProductTransferEligibilityResult - Result of the product transfer eligibility validation.
type ValidateProductTransferEligibilityResult struct {
	// Validation error details.
	ErrorDetails *ValidateProductTransferEligibilityError `json:"errorDetails,omitempty"`

	// READ-ONLY; Specifies whether the transfer is eligible or not.
	IsMoveEligible *bool `json:"isMoveEligible,omitempty" azure:"ro"`
}

// ValidateSubscriptionTransferEligibilityError - Error details of the transfer eligibility validation
type ValidateSubscriptionTransferEligibilityError struct {
	// Error code for the product transfer validation.
	Code *SubscriptionTransferValidationErrorCode `json:"code,omitempty"`

	// Detailed error message explaining the error.
	Details *string `json:"details,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`
}

// ValidateSubscriptionTransferEligibilityResult - Result of the transfer eligibility validation.
type ValidateSubscriptionTransferEligibilityResult struct {
	// Validation error details.
	ErrorDetails *ValidateSubscriptionTransferEligibilityError `json:"errorDetails,omitempty"`

	// READ-ONLY; Specifies whether the subscription is eligible to be transferred.
	IsMoveEligible *bool `json:"isMoveEligible,omitempty" azure:"ro"`
}
