//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armblueprint

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactList.
func (a *ArtifactList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			a.Value, err = unmarshalArtifactClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactPropertiesBase.
func (a ArtifactPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", a.DependsOn)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentDeploymentJob.
func (a AssignmentDeploymentJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "action", a.Action)
	populate(objectMap, "history", a.History)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "jobState", a.JobState)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "requestUri", a.RequestURI)
	populate(objectMap, "result", a.Result)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentDeploymentJobResult.
func (a AssignmentDeploymentJobResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", a.Error)
	populate(objectMap, "resources", a.Resources)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentJobCreatedResource.
func (a AssignmentJobCreatedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentLockSettings.
func (a AssignmentLockSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "excludedActions", a.ExcludedActions)
	populate(objectMap, "excludedPrincipals", a.ExcludedPrincipals)
	populate(objectMap, "mode", a.Mode)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentOperationProperties.
func (a AssignmentOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assignmentState", a.AssignmentState)
	populate(objectMap, "blueprintVersion", a.BlueprintVersion)
	populate(objectMap, "deployments", a.Deployments)
	populate(objectMap, "timeCreated", a.TimeCreated)
	populate(objectMap, "timeFinished", a.TimeFinished)
	populate(objectMap, "timeStarted", a.TimeStarted)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentProperties.
func (a AssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blueprintId", a.BlueprintID)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "locks", a.Locks)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceGroups", a.ResourceGroups)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AssignmentStatus.
func (a AssignmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastModified", a.LastModified)
	populate(objectMap, "managedResources", a.ManagedResources)
	populateTimeRFC3339(objectMap, "timeCreated", a.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssignmentStatus.
func (a *AssignmentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &a.LastModified)
			delete(rawMsg, key)
		case "managedResources":
			err = unpopulate(val, "ManagedResources", &a.ManagedResources)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &a.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ParameterDefinition.
func (p ParameterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedValues", p.AllowedValues)
	populate(objectMap, "defaultValue", &p.DefaultValue)
	populate(objectMap, "metadata", p.Metadata)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentArtifact.
func (p PolicyAssignmentArtifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	objectMap["kind"] = ArtifactKindPolicyAssignment
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyAssignmentArtifact.
func (p *PolicyAssignmentArtifact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyAssignmentArtifactProperties.
func (p PolicyAssignmentArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", p.DependsOn)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "layout", &p.Layout)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "resourceGroups", p.ResourceGroups)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "targetScope", p.TargetScope)
	populate(objectMap, "versions", &p.Versions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PublishedBlueprintProperties.
func (p PublishedBlueprintProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blueprintName", p.BlueprintName)
	populate(objectMap, "changeNotes", p.ChangeNotes)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "resourceGroups", p.ResourceGroups)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "targetScope", p.TargetScope)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGroupDefinition.
func (r ResourceGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", r.DependsOn)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "metadata", r.Metadata)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceStatusBase.
func (r ResourceStatusBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastModified", r.LastModified)
	populateTimeRFC3339(objectMap, "timeCreated", r.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceStatusBase.
func (r *ResourceStatusBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &r.LastModified)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &r.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentArtifact.
func (r RoleAssignmentArtifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = ArtifactKindRoleAssignment
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentArtifact.
func (r *RoleAssignmentArtifact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentArtifactProperties.
func (r RoleAssignmentArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", r.DependsOn)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "principalIds", &r.PrincipalIDs)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharedBlueprintProperties.
func (s SharedBlueprintProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "resourceGroups", s.ResourceGroups)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "targetScope", s.TargetScope)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastModified", s.LastModified)
	populateTimeRFC3339(objectMap, "timeCreated", s.TimeCreated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Status.
func (s *Status) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &s.LastModified)
			delete(rawMsg, key)
		case "timeCreated":
			err = unpopulateTimeRFC3339(val, "TimeCreated", &s.TimeCreated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TemplateArtifact.
func (t TemplateArtifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	objectMap["kind"] = ArtifactKindTemplate
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TemplateArtifact.
func (t *TemplateArtifact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TemplateArtifactProperties.
func (t TemplateArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", t.DependsOn)
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "parameters", t.Parameters)
	populate(objectMap, "resourceGroup", t.ResourceGroup)
	populate(objectMap, "template", &t.Template)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
