//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsqlvirtualmachine

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AdditionalFeaturesServerConfigurations.
func (a AdditionalFeaturesServerConfigurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isRServicesEnabled", a.IsRServicesEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdditionalFeaturesServerConfigurations.
func (a *AdditionalFeaturesServerConfigurations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isRServicesEnabled":
			err = unpopulate(val, "IsRServicesEnabled", &a.IsRServicesEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgConfiguration.
func (a AgConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "replicas", a.Replicas)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgConfiguration.
func (a *AgConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replicas":
			err = unpopulate(val, "Replicas", &a.Replicas)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgReplica.
func (a AgReplica) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commit", a.Commit)
	populate(objectMap, "failover", a.Failover)
	populate(objectMap, "readableSecondary", a.ReadableSecondary)
	populate(objectMap, "role", a.Role)
	populate(objectMap, "sqlVirtualMachineInstanceId", a.SQLVirtualMachineInstanceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgReplica.
func (a *AgReplica) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commit":
			err = unpopulate(val, "Commit", &a.Commit)
			delete(rawMsg, key)
		case "failover":
			err = unpopulate(val, "Failover", &a.Failover)
			delete(rawMsg, key)
		case "readableSecondary":
			err = unpopulate(val, "ReadableSecondary", &a.ReadableSecondary)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &a.Role)
			delete(rawMsg, key)
		case "sqlVirtualMachineInstanceId":
			err = unpopulate(val, "SQLVirtualMachineInstanceID", &a.SQLVirtualMachineInstanceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentSettings.
func (a AssessmentSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enable", a.Enable)
	populate(objectMap, "runImmediately", a.RunImmediately)
	populate(objectMap, "schedule", a.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentSettings.
func (a *AssessmentSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enable":
			err = unpopulate(val, "Enable", &a.Enable)
			delete(rawMsg, key)
		case "runImmediately":
			err = unpopulate(val, "RunImmediately", &a.RunImmediately)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &a.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoBackupSettings.
func (a AutoBackupSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backupScheduleType", a.BackupScheduleType)
	populate(objectMap, "backupSystemDbs", a.BackupSystemDbs)
	populate(objectMap, "daysOfWeek", a.DaysOfWeek)
	populate(objectMap, "enable", a.Enable)
	populate(objectMap, "enableEncryption", a.EnableEncryption)
	populate(objectMap, "fullBackupFrequency", a.FullBackupFrequency)
	populate(objectMap, "fullBackupStartTime", a.FullBackupStartTime)
	populate(objectMap, "fullBackupWindowHours", a.FullBackupWindowHours)
	populate(objectMap, "logBackupFrequency", a.LogBackupFrequency)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "retentionPeriod", a.RetentionPeriod)
	populate(objectMap, "storageAccessKey", a.StorageAccessKey)
	populate(objectMap, "storageAccountUrl", a.StorageAccountURL)
	populate(objectMap, "storageContainerName", a.StorageContainerName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoBackupSettings.
func (a *AutoBackupSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupScheduleType":
			err = unpopulate(val, "BackupScheduleType", &a.BackupScheduleType)
			delete(rawMsg, key)
		case "backupSystemDbs":
			err = unpopulate(val, "BackupSystemDbs", &a.BackupSystemDbs)
			delete(rawMsg, key)
		case "daysOfWeek":
			err = unpopulate(val, "DaysOfWeek", &a.DaysOfWeek)
			delete(rawMsg, key)
		case "enable":
			err = unpopulate(val, "Enable", &a.Enable)
			delete(rawMsg, key)
		case "enableEncryption":
			err = unpopulate(val, "EnableEncryption", &a.EnableEncryption)
			delete(rawMsg, key)
		case "fullBackupFrequency":
			err = unpopulate(val, "FullBackupFrequency", &a.FullBackupFrequency)
			delete(rawMsg, key)
		case "fullBackupStartTime":
			err = unpopulate(val, "FullBackupStartTime", &a.FullBackupStartTime)
			delete(rawMsg, key)
		case "fullBackupWindowHours":
			err = unpopulate(val, "FullBackupWindowHours", &a.FullBackupWindowHours)
			delete(rawMsg, key)
		case "logBackupFrequency":
			err = unpopulate(val, "LogBackupFrequency", &a.LogBackupFrequency)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "retentionPeriod":
			err = unpopulate(val, "RetentionPeriod", &a.RetentionPeriod)
			delete(rawMsg, key)
		case "storageAccessKey":
			err = unpopulate(val, "StorageAccessKey", &a.StorageAccessKey)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &a.StorageAccountURL)
			delete(rawMsg, key)
		case "storageContainerName":
			err = unpopulate(val, "StorageContainerName", &a.StorageContainerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoPatchingSettings.
func (a AutoPatchingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dayOfWeek", a.DayOfWeek)
	populate(objectMap, "enable", a.Enable)
	populate(objectMap, "maintenanceWindowDuration", a.MaintenanceWindowDuration)
	populate(objectMap, "maintenanceWindowStartingHour", a.MaintenanceWindowStartingHour)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoPatchingSettings.
func (a *AutoPatchingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &a.DayOfWeek)
			delete(rawMsg, key)
		case "enable":
			err = unpopulate(val, "Enable", &a.Enable)
			delete(rawMsg, key)
		case "maintenanceWindowDuration":
			err = unpopulate(val, "MaintenanceWindowDuration", &a.MaintenanceWindowDuration)
			delete(rawMsg, key)
		case "maintenanceWindowStartingHour":
			err = unpopulate(val, "MaintenanceWindowStartingHour", &a.MaintenanceWindowStartingHour)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityGroupListener.
func (a AvailabilityGroupListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityGroupListener.
func (a *AvailabilityGroupListener) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityGroupListenerListResult.
func (a AvailabilityGroupListenerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityGroupListenerListResult.
func (a *AvailabilityGroupListenerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityGroupListenerProperties.
func (a AvailabilityGroupListenerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "availabilityGroupConfiguration", a.AvailabilityGroupConfiguration)
	populate(objectMap, "availabilityGroupName", a.AvailabilityGroupName)
	populate(objectMap, "createDefaultAvailabilityGroupIfNotExist", a.CreateDefaultAvailabilityGroupIfNotExist)
	populate(objectMap, "loadBalancerConfigurations", a.LoadBalancerConfigurations)
	populate(objectMap, "multiSubnetIpConfigurations", a.MultiSubnetIPConfigurations)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityGroupListenerProperties.
func (a *AvailabilityGroupListenerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityGroupConfiguration":
			err = unpopulate(val, "AvailabilityGroupConfiguration", &a.AvailabilityGroupConfiguration)
			delete(rawMsg, key)
		case "availabilityGroupName":
			err = unpopulate(val, "AvailabilityGroupName", &a.AvailabilityGroupName)
			delete(rawMsg, key)
		case "createDefaultAvailabilityGroupIfNotExist":
			err = unpopulate(val, "CreateDefaultAvailabilityGroupIfNotExist", &a.CreateDefaultAvailabilityGroupIfNotExist)
			delete(rawMsg, key)
		case "loadBalancerConfigurations":
			err = unpopulate(val, "LoadBalancerConfigurations", &a.LoadBalancerConfigurations)
			delete(rawMsg, key)
		case "multiSubnetIpConfigurations":
			err = unpopulate(val, "MultiSubnetIPConfigurations", &a.MultiSubnetIPConfigurations)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "systemData", g.SystemData)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Group.
func (g *Group) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &g.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupListResult.
func (g GroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupListResult.
func (g *GroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupProperties.
func (g GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clusterConfiguration", g.ClusterConfiguration)
	populate(objectMap, "clusterManagerType", g.ClusterManagerType)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "sqlImageOffer", g.SQLImageOffer)
	populate(objectMap, "sqlImageSku", g.SQLImageSKU)
	populate(objectMap, "scaleType", g.ScaleType)
	populate(objectMap, "wsfcDomainProfile", g.WsfcDomainProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupProperties.
func (g *GroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterConfiguration":
			err = unpopulate(val, "ClusterConfiguration", &g.ClusterConfiguration)
			delete(rawMsg, key)
		case "clusterManagerType":
			err = unpopulate(val, "ClusterManagerType", &g.ClusterManagerType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "sqlImageOffer":
			err = unpopulate(val, "SQLImageOffer", &g.SQLImageOffer)
			delete(rawMsg, key)
		case "sqlImageSku":
			err = unpopulate(val, "SQLImageSKU", &g.SQLImageSKU)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &g.ScaleType)
			delete(rawMsg, key)
		case "wsfcDomainProfile":
			err = unpopulate(val, "WsfcDomainProfile", &g.WsfcDomainProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupUpdate.
func (g GroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", g.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupUpdate.
func (g *GroupUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCredentialSettings.
func (k KeyVaultCredentialSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureKeyVaultUrl", k.AzureKeyVaultURL)
	populate(objectMap, "credentialName", k.CredentialName)
	populate(objectMap, "enable", k.Enable)
	populate(objectMap, "servicePrincipalName", k.ServicePrincipalName)
	populate(objectMap, "servicePrincipalSecret", k.ServicePrincipalSecret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCredentialSettings.
func (k *KeyVaultCredentialSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureKeyVaultUrl":
			err = unpopulate(val, "AzureKeyVaultURL", &k.AzureKeyVaultURL)
			delete(rawMsg, key)
		case "credentialName":
			err = unpopulate(val, "CredentialName", &k.CredentialName)
			delete(rawMsg, key)
		case "enable":
			err = unpopulate(val, "Enable", &k.Enable)
			delete(rawMsg, key)
		case "servicePrincipalName":
			err = unpopulate(val, "ServicePrincipalName", &k.ServicePrincipalName)
			delete(rawMsg, key)
		case "servicePrincipalSecret":
			err = unpopulate(val, "ServicePrincipalSecret", &k.ServicePrincipalSecret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListResult.
func (l ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListResult.
func (l *ListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerConfiguration.
func (l LoadBalancerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "loadBalancerResourceId", l.LoadBalancerResourceID)
	populate(objectMap, "privateIpAddress", l.PrivateIPAddress)
	populate(objectMap, "probePort", l.ProbePort)
	populate(objectMap, "publicIpAddressResourceId", l.PublicIPAddressResourceID)
	populate(objectMap, "sqlVirtualMachineInstances", l.SQLVirtualMachineInstances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerConfiguration.
func (l *LoadBalancerConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "loadBalancerResourceId":
			err = unpopulate(val, "LoadBalancerResourceID", &l.LoadBalancerResourceID)
			delete(rawMsg, key)
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &l.PrivateIPAddress)
			delete(rawMsg, key)
		case "probePort":
			err = unpopulate(val, "ProbePort", &l.ProbePort)
			delete(rawMsg, key)
		case "publicIpAddressResourceId":
			err = unpopulate(val, "PublicIPAddressResourceID", &l.PublicIPAddressResourceID)
			delete(rawMsg, key)
		case "sqlVirtualMachineInstances":
			err = unpopulate(val, "SQLVirtualMachineInstances", &l.SQLVirtualMachineInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MultiSubnetIPConfiguration.
func (m MultiSubnetIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateIpAddress", m.PrivateIPAddress)
	populate(objectMap, "sqlVirtualMachineInstance", m.SQLVirtualMachineInstance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MultiSubnetIPConfiguration.
func (m *MultiSubnetIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &m.PrivateIPAddress)
			delete(rawMsg, key)
		case "sqlVirtualMachineInstance":
			err = unpopulate(val, "SQLVirtualMachineInstance", &m.SQLVirtualMachineInstance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateIPAddress.
func (p PrivateIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipAddress", p.IPAddress)
	populate(objectMap, "subnetResourceId", p.SubnetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateIPAddress.
func (p *PrivateIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &p.IPAddress)
			delete(rawMsg, key)
		case "subnetResourceId":
			err = unpopulate(val, "SubnetResourceID", &p.SubnetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentSettings", p.AssessmentSettings)
	populate(objectMap, "autoBackupSettings", p.AutoBackupSettings)
	populate(objectMap, "autoPatchingSettings", p.AutoPatchingSettings)
	populate(objectMap, "enableAutomaticUpgrade", p.EnableAutomaticUpgrade)
	populate(objectMap, "keyVaultCredentialSettings", p.KeyVaultCredentialSettings)
	populate(objectMap, "leastPrivilegeMode", p.LeastPrivilegeMode)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "sqlImageOffer", p.SQLImageOffer)
	populate(objectMap, "sqlImageSku", p.SQLImageSKU)
	populate(objectMap, "sqlManagement", p.SQLManagement)
	populate(objectMap, "sqlServerLicenseType", p.SQLServerLicenseType)
	populate(objectMap, "sqlVirtualMachineGroupResourceId", p.SQLVirtualMachineGroupResourceID)
	populate(objectMap, "serverConfigurationsManagementSettings", p.ServerConfigurationsManagementSettings)
	populate(objectMap, "storageConfigurationSettings", p.StorageConfigurationSettings)
	populate(objectMap, "virtualMachineResourceId", p.VirtualMachineResourceID)
	populate(objectMap, "wsfcDomainCredentials", p.WsfcDomainCredentials)
	populate(objectMap, "wsfcStaticIp", p.WsfcStaticIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Properties.
func (p *Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentSettings":
			err = unpopulate(val, "AssessmentSettings", &p.AssessmentSettings)
			delete(rawMsg, key)
		case "autoBackupSettings":
			err = unpopulate(val, "AutoBackupSettings", &p.AutoBackupSettings)
			delete(rawMsg, key)
		case "autoPatchingSettings":
			err = unpopulate(val, "AutoPatchingSettings", &p.AutoPatchingSettings)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &p.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "keyVaultCredentialSettings":
			err = unpopulate(val, "KeyVaultCredentialSettings", &p.KeyVaultCredentialSettings)
			delete(rawMsg, key)
		case "leastPrivilegeMode":
			err = unpopulate(val, "LeastPrivilegeMode", &p.LeastPrivilegeMode)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "sqlImageOffer":
			err = unpopulate(val, "SQLImageOffer", &p.SQLImageOffer)
			delete(rawMsg, key)
		case "sqlImageSku":
			err = unpopulate(val, "SQLImageSKU", &p.SQLImageSKU)
			delete(rawMsg, key)
		case "sqlManagement":
			err = unpopulate(val, "SQLManagement", &p.SQLManagement)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &p.SQLServerLicenseType)
			delete(rawMsg, key)
		case "sqlVirtualMachineGroupResourceId":
			err = unpopulate(val, "SQLVirtualMachineGroupResourceID", &p.SQLVirtualMachineGroupResourceID)
			delete(rawMsg, key)
		case "serverConfigurationsManagementSettings":
			err = unpopulate(val, "ServerConfigurationsManagementSettings", &p.ServerConfigurationsManagementSettings)
			delete(rawMsg, key)
		case "storageConfigurationSettings":
			err = unpopulate(val, "StorageConfigurationSettings", &p.StorageConfigurationSettings)
			delete(rawMsg, key)
		case "virtualMachineResourceId":
			err = unpopulate(val, "VirtualMachineResourceID", &p.VirtualMachineResourceID)
			delete(rawMsg, key)
		case "wsfcDomainCredentials":
			err = unpopulate(val, "WsfcDomainCredentials", &p.WsfcDomainCredentials)
			delete(rawMsg, key)
		case "wsfcStaticIp":
			err = unpopulate(val, "WsfcStaticIP", &p.WsfcStaticIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentity.
func (r ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "tenantId", r.TenantID)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIdentity.
func (r *ResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLConnectivityUpdateSettings.
func (s SQLConnectivityUpdateSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectivityType", s.ConnectivityType)
	populate(objectMap, "port", s.Port)
	populate(objectMap, "sqlAuthUpdatePassword", s.SQLAuthUpdatePassword)
	populate(objectMap, "sqlAuthUpdateUserName", s.SQLAuthUpdateUserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLConnectivityUpdateSettings.
func (s *SQLConnectivityUpdateSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectivityType":
			err = unpopulate(val, "ConnectivityType", &s.ConnectivityType)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &s.Port)
			delete(rawMsg, key)
		case "sqlAuthUpdatePassword":
			err = unpopulate(val, "SQLAuthUpdatePassword", &s.SQLAuthUpdatePassword)
			delete(rawMsg, key)
		case "sqlAuthUpdateUserName":
			err = unpopulate(val, "SQLAuthUpdateUserName", &s.SQLAuthUpdateUserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLInstanceSettings.
func (s SQLInstanceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "collation", s.Collation)
	populate(objectMap, "isIfiEnabled", s.IsIfiEnabled)
	populate(objectMap, "isLpimEnabled", s.IsLpimEnabled)
	populate(objectMap, "isOptimizeForAdHocWorkloadsEnabled", s.IsOptimizeForAdHocWorkloadsEnabled)
	populate(objectMap, "maxDop", s.MaxDop)
	populate(objectMap, "maxServerMemoryMB", s.MaxServerMemoryMB)
	populate(objectMap, "minServerMemoryMB", s.MinServerMemoryMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLInstanceSettings.
func (s *SQLInstanceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collation":
			err = unpopulate(val, "Collation", &s.Collation)
			delete(rawMsg, key)
		case "isIfiEnabled":
			err = unpopulate(val, "IsIfiEnabled", &s.IsIfiEnabled)
			delete(rawMsg, key)
		case "isLpimEnabled":
			err = unpopulate(val, "IsLpimEnabled", &s.IsLpimEnabled)
			delete(rawMsg, key)
		case "isOptimizeForAdHocWorkloadsEnabled":
			err = unpopulate(val, "IsOptimizeForAdHocWorkloadsEnabled", &s.IsOptimizeForAdHocWorkloadsEnabled)
			delete(rawMsg, key)
		case "maxDop":
			err = unpopulate(val, "MaxDop", &s.MaxDop)
			delete(rawMsg, key)
		case "maxServerMemoryMB":
			err = unpopulate(val, "MaxServerMemoryMB", &s.MaxServerMemoryMB)
			delete(rawMsg, key)
		case "minServerMemoryMB":
			err = unpopulate(val, "MinServerMemoryMB", &s.MinServerMemoryMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLStorageSettings.
func (s SQLStorageSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultFilePath", s.DefaultFilePath)
	populate(objectMap, "luns", s.Luns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLStorageSettings.
func (s *SQLStorageSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultFilePath":
			err = unpopulate(val, "DefaultFilePath", &s.DefaultFilePath)
			delete(rawMsg, key)
		case "luns":
			err = unpopulate(val, "Luns", &s.Luns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLStorageUpdateSettings.
func (s SQLStorageUpdateSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskConfigurationType", s.DiskConfigurationType)
	populate(objectMap, "diskCount", s.DiskCount)
	populate(objectMap, "startingDeviceId", s.StartingDeviceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLStorageUpdateSettings.
func (s *SQLStorageUpdateSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskConfigurationType":
			err = unpopulate(val, "DiskConfigurationType", &s.DiskConfigurationType)
			delete(rawMsg, key)
		case "diskCount":
			err = unpopulate(val, "DiskCount", &s.DiskCount)
			delete(rawMsg, key)
		case "startingDeviceId":
			err = unpopulate(val, "StartingDeviceID", &s.StartingDeviceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLTempDbSettings.
func (s SQLTempDbSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataFileCount", s.DataFileCount)
	populate(objectMap, "dataFileSize", s.DataFileSize)
	populate(objectMap, "dataGrowth", s.DataGrowth)
	populate(objectMap, "defaultFilePath", s.DefaultFilePath)
	populate(objectMap, "logFileSize", s.LogFileSize)
	populate(objectMap, "logGrowth", s.LogGrowth)
	populate(objectMap, "luns", s.Luns)
	populate(objectMap, "persistFolder", s.PersistFolder)
	populate(objectMap, "persistFolderPath", s.PersistFolderPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLTempDbSettings.
func (s *SQLTempDbSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFileCount":
			err = unpopulate(val, "DataFileCount", &s.DataFileCount)
			delete(rawMsg, key)
		case "dataFileSize":
			err = unpopulate(val, "DataFileSize", &s.DataFileSize)
			delete(rawMsg, key)
		case "dataGrowth":
			err = unpopulate(val, "DataGrowth", &s.DataGrowth)
			delete(rawMsg, key)
		case "defaultFilePath":
			err = unpopulate(val, "DefaultFilePath", &s.DefaultFilePath)
			delete(rawMsg, key)
		case "logFileSize":
			err = unpopulate(val, "LogFileSize", &s.LogFileSize)
			delete(rawMsg, key)
		case "logGrowth":
			err = unpopulate(val, "LogGrowth", &s.LogGrowth)
			delete(rawMsg, key)
		case "luns":
			err = unpopulate(val, "Luns", &s.Luns)
			delete(rawMsg, key)
		case "persistFolder":
			err = unpopulate(val, "PersistFolder", &s.PersistFolder)
			delete(rawMsg, key)
		case "persistFolderPath":
			err = unpopulate(val, "PersistFolderPath", &s.PersistFolderPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLVirtualMachine.
func (s SQLVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLVirtualMachine.
func (s *SQLVirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLWorkloadTypeUpdateSettings.
func (s SQLWorkloadTypeUpdateSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sqlWorkloadType", s.SQLWorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLWorkloadTypeUpdateSettings.
func (s *SQLWorkloadTypeUpdateSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sqlWorkloadType":
			err = unpopulate(val, "SQLWorkloadType", &s.SQLWorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dayOfWeek", s.DayOfWeek)
	populate(objectMap, "enable", s.Enable)
	populate(objectMap, "monthlyOccurrence", s.MonthlyOccurrence)
	populate(objectMap, "startTime", s.StartTime)
	populate(objectMap, "weeklyInterval", s.WeeklyInterval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Schedule.
func (s *Schedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &s.DayOfWeek)
			delete(rawMsg, key)
		case "enable":
			err = unpopulate(val, "Enable", &s.Enable)
			delete(rawMsg, key)
		case "monthlyOccurrence":
			err = unpopulate(val, "MonthlyOccurrence", &s.MonthlyOccurrence)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "weeklyInterval":
			err = unpopulate(val, "WeeklyInterval", &s.WeeklyInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerConfigurationsManagementSettings.
func (s ServerConfigurationsManagementSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalFeaturesServerConfigurations", s.AdditionalFeaturesServerConfigurations)
	populate(objectMap, "sqlConnectivityUpdateSettings", s.SQLConnectivityUpdateSettings)
	populate(objectMap, "sqlInstanceSettings", s.SQLInstanceSettings)
	populate(objectMap, "sqlStorageUpdateSettings", s.SQLStorageUpdateSettings)
	populate(objectMap, "sqlWorkloadTypeUpdateSettings", s.SQLWorkloadTypeUpdateSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerConfigurationsManagementSettings.
func (s *ServerConfigurationsManagementSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalFeaturesServerConfigurations":
			err = unpopulate(val, "AdditionalFeaturesServerConfigurations", &s.AdditionalFeaturesServerConfigurations)
			delete(rawMsg, key)
		case "sqlConnectivityUpdateSettings":
			err = unpopulate(val, "SQLConnectivityUpdateSettings", &s.SQLConnectivityUpdateSettings)
			delete(rawMsg, key)
		case "sqlInstanceSettings":
			err = unpopulate(val, "SQLInstanceSettings", &s.SQLInstanceSettings)
			delete(rawMsg, key)
		case "sqlStorageUpdateSettings":
			err = unpopulate(val, "SQLStorageUpdateSettings", &s.SQLStorageUpdateSettings)
			delete(rawMsg, key)
		case "sqlWorkloadTypeUpdateSettings":
			err = unpopulate(val, "SQLWorkloadTypeUpdateSettings", &s.SQLWorkloadTypeUpdateSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageConfigurationSettings.
func (s StorageConfigurationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskConfigurationType", s.DiskConfigurationType)
	populate(objectMap, "sqlDataSettings", s.SQLDataSettings)
	populate(objectMap, "sqlLogSettings", s.SQLLogSettings)
	populate(objectMap, "sqlSystemDbOnDataDisk", s.SQLSystemDbOnDataDisk)
	populate(objectMap, "sqlTempDbSettings", s.SQLTempDbSettings)
	populate(objectMap, "storageWorkloadType", s.StorageWorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageConfigurationSettings.
func (s *StorageConfigurationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskConfigurationType":
			err = unpopulate(val, "DiskConfigurationType", &s.DiskConfigurationType)
			delete(rawMsg, key)
		case "sqlDataSettings":
			err = unpopulate(val, "SQLDataSettings", &s.SQLDataSettings)
			delete(rawMsg, key)
		case "sqlLogSettings":
			err = unpopulate(val, "SQLLogSettings", &s.SQLLogSettings)
			delete(rawMsg, key)
		case "sqlSystemDbOnDataDisk":
			err = unpopulate(val, "SQLSystemDbOnDataDisk", &s.SQLSystemDbOnDataDisk)
			delete(rawMsg, key)
		case "sqlTempDbSettings":
			err = unpopulate(val, "SQLTempDbSettings", &s.SQLTempDbSettings)
			delete(rawMsg, key)
		case "storageWorkloadType":
			err = unpopulate(val, "StorageWorkloadType", &s.StorageWorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Update.
func (u *Update) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WsfcDomainCredentials.
func (w WsfcDomainCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clusterBootstrapAccountPassword", w.ClusterBootstrapAccountPassword)
	populate(objectMap, "clusterOperatorAccountPassword", w.ClusterOperatorAccountPassword)
	populate(objectMap, "sqlServiceAccountPassword", w.SQLServiceAccountPassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WsfcDomainCredentials.
func (w *WsfcDomainCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterBootstrapAccountPassword":
			err = unpopulate(val, "ClusterBootstrapAccountPassword", &w.ClusterBootstrapAccountPassword)
			delete(rawMsg, key)
		case "clusterOperatorAccountPassword":
			err = unpopulate(val, "ClusterOperatorAccountPassword", &w.ClusterOperatorAccountPassword)
			delete(rawMsg, key)
		case "sqlServiceAccountPassword":
			err = unpopulate(val, "SQLServiceAccountPassword", &w.SQLServiceAccountPassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WsfcDomainProfile.
func (w WsfcDomainProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clusterBootstrapAccount", w.ClusterBootstrapAccount)
	populate(objectMap, "clusterOperatorAccount", w.ClusterOperatorAccount)
	populate(objectMap, "clusterSubnetType", w.ClusterSubnetType)
	populate(objectMap, "domainFqdn", w.DomainFqdn)
	populate(objectMap, "fileShareWitnessPath", w.FileShareWitnessPath)
	populate(objectMap, "ouPath", w.OuPath)
	populate(objectMap, "sqlServiceAccount", w.SQLServiceAccount)
	populate(objectMap, "storageAccountPrimaryKey", w.StorageAccountPrimaryKey)
	populate(objectMap, "storageAccountUrl", w.StorageAccountURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WsfcDomainProfile.
func (w *WsfcDomainProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterBootstrapAccount":
			err = unpopulate(val, "ClusterBootstrapAccount", &w.ClusterBootstrapAccount)
			delete(rawMsg, key)
		case "clusterOperatorAccount":
			err = unpopulate(val, "ClusterOperatorAccount", &w.ClusterOperatorAccount)
			delete(rawMsg, key)
		case "clusterSubnetType":
			err = unpopulate(val, "ClusterSubnetType", &w.ClusterSubnetType)
			delete(rawMsg, key)
		case "domainFqdn":
			err = unpopulate(val, "DomainFqdn", &w.DomainFqdn)
			delete(rawMsg, key)
		case "fileShareWitnessPath":
			err = unpopulate(val, "FileShareWitnessPath", &w.FileShareWitnessPath)
			delete(rawMsg, key)
		case "ouPath":
			err = unpopulate(val, "OuPath", &w.OuPath)
			delete(rawMsg, key)
		case "sqlServiceAccount":
			err = unpopulate(val, "SQLServiceAccount", &w.SQLServiceAccount)
			delete(rawMsg, key)
		case "storageAccountPrimaryKey":
			err = unpopulate(val, "StorageAccountPrimaryKey", &w.StorageAccountPrimaryKey)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &w.StorageAccountURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
