# 《Node.js 包教不包会》 -- by alsotang


## 为何写作此课程


在 CNode(https://cnodejs.org/) 混了那么久，解答了不少 Node.js 初学者们的问题。回头想想，那些问题所需要的思路都不难，但大部分人由于练手机会少，所以在遇到问题的时候很无措。国内唯一一本排的上号的 Node.js 书是 @朴灵(https://github.com/JacksonTian) 的 《深入浅出Node.js》(http://book.douban.com/subject/25768396/ )，但这本书离实战还是比较远的。

这个课程是希望提供更多的 Node.js 实战机会，通过每一节精心安排的课程目标，让 Node.js 的初学者们可以循序渐进地，有目的有挑战地开展 Node.js 的学习。

## 广告

**需要内推腾讯的同学请参照此贴：** https://cnodejs.org/topic/58351689bde2b59e06141e9f

更多 Node.js 入门资料请前往：https://cnodejs.org/getstart

新手搭建 Node.js 云主机，推荐使用无需备案的 [DigitalOcean(https://www.digitalocean.com/)](https://www.digitalocean.com/?refcode=eba02656eeb3)

## 课程列表

* Lesson 0: [《搭建 Node.js 开发环境》](https://github.com/alsotang/node-lessons/tree/master/lesson0)
* Lesson 1: [《一个最简单的 express 应用》](https://github.com/alsotang/node-lessons/tree/master/lesson1)
* Lesson 2: [《学习使用外部模块》](https://github.com/alsotang/node-lessons/tree/master/lesson2)
* Lesson 3: [《使用 superagent 与 cheerio 完成简单爬虫》](https://github.com/alsotang/node-lessons/tree/master/lesson3)
* Lesson 4: [《使用 eventproxy 控制并发》](https://github.com/alsotang/node-lessons/tree/master/lesson4)
* Lesson 5: [《使用 async 控制并发》](https://github.com/alsotang/node-lessons/tree/master/lesson5)
* Lesson 6: [《测试用例：mocha，should，istanbul》](https://github.com/alsotang/node-lessons/tree/master/lesson6)
* Lesson 7: [《浏览器端测试：mocha，chai，phantomjs》](https://github.com/alsotang/node-lessons/tree/master/lesson7) -- by [@elrrrrrrr](https://github.com/elrrrrrrr)
* Lesson 8: [《测试用例：supertest》](https://github.com/alsotang/node-lessons/tree/master/lesson8)
* Lesson 9: [《正则表达式》](https://github.com/alsotang/node-lessons/tree/master/lesson9)
* Lesson 10: [《benchmark 怎么写》](https://github.com/alsotang/node-lessons/tree/master/lesson10)
* Lesson 11: [《作用域与闭包：this，var，(function () {})》](https://github.com/alsotang/node-lessons/tree/master/lesson11) -- by [@Ricardo-Li](https://github.com/Ricardo-Li/)
* Lesson 12: [《线上部署：heroku》](https://github.com/alsotang/node-lessons/tree/master/lesson12)
* Lesson 13: [《持续集成平台：travis》](https://github.com/alsotang/node-lessons/tree/master/lesson13)
* Lesson 14: [《js 中的那些最佳实践》](https://github.com/alsotang/node-lessons/tree/master/lesson14)
* Lesson 15: [《Mongodb 与 Mongoose 的使用》](https://github.com/alsotang/node-lessons/tree/master/lesson15)
* Lesson 16: [《cookie 与 session》](https://github.com/alsotang/node-lessons/tree/master/lesson16) -- by [@Ricardo-Li](https://github.com/Ricardo-Li/)
* Lesson 17: [《使用 promise 替代回调函数》](https://github.com/alsotang/node-lessons/tree/master/lesson17) -- by [@eeandrew](https://github.com/eeandrew)
* Lesson 18: [《何为 connect 中间件》](https://github.com/alsotang/node-lessons/tree/master/lesson18) -- by [@albin3](https://github.com/albin3)

## 计划

* 《http 中各个 header 的含义》
* 《操作 mysql》
* 《在全新的 vps 上搭建 node.js、mongodb、nginx》
* 《一个简单的 blog 程序》

## 本课程特点

* 每一课的课程挑战如果有能力完成，则可考虑放弃阅读课程内容
* 对 web 开发初学者不友好，对 Windows 用户不友好，对 ruby on rails 开发者友好
* 内容笼统，课程重点随心所欲

## License

MIT
