// Reconcile DEP-5 debian/copyright to licensecheck
//
// Copyright : 2025 P Blackman
// License   : BSD-2-clause
//
// Test for false positive on 0BSD OR ... licence
//

unit bsd0;
{$mode delphi}

interface

function CheckBSD0 (Fname : AnsiString; Dep5, Actual : String) : Boolean;


implementation uses SysUtils, StrUtils, support;

const  B0 : string = '0BSD';
    B0txt : string = '0BSD OR BSL-1.0 OR MIT-0';

function GetFileLicense (Fname : AnsiString) : String;
const MaxLines : Integer = 10;
var Lines : Integer;
    Line  : AnsiString;
    Lfile : Text;

begin
    result := '';
    Lines := 0;
    if OpenFile (FName, Lfile) then
    begin
        while not EOF (Lfile) and (Lines < MaxLines) do
        begin
            ReadLn (Lfile, Line);

            if (NPos (B0txt, Line, 1) > 0) then
            begin
                result := B0txt;
                Lines := MaxLines; // terminate loop
            end;
        end;
    end;
end;

// Return true if Actual is a match for d/copyright
function CheckBSD0 (Fname : AnsiString; Dep5, Actual : String) : Boolean;
begin
    result := False;

    if (Dep5 = Actual) then
        result := True
    else
    if  (CompareText (Dep5, B0txt) =  0)
    and (Actual = B0) then
        if GetFileLicense (FName) = B0txt then
            result := True;
end;

end.
