// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright 2024 NXP
 */

#include <linux/init.h>
#include <linux/mod_devicetable.h>
#include <linux/module.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-imx.h"

enum imx91_pads {
	IMX91_PAD_DAP_TDI = 0,
	IMX91_PAD_DAP_TMS_SWDIO = 1,
	IMX91_PAD_DAP_TCLK_SWCLK = 2,
	IMX91_PAD_DAP_TDO_TRACESWO = 3,
	IMX91_PAD_GPIO_IO00 = 4,
	IMX91_PAD_GPIO_IO01 = 5,
	IMX91_PAD_GPIO_IO02 = 6,
	IMX91_PAD_GPIO_IO03 = 7,
	IMX91_PAD_GPIO_IO04 = 8,
	IMX91_PAD_GPIO_IO05 = 9,
	IMX91_PAD_GPIO_IO06 = 10,
	IMX91_PAD_GPIO_IO07 = 11,
	IMX91_PAD_GPIO_IO08 = 12,
	IMX91_PAD_GPIO_IO09 = 13,
	IMX91_PAD_GPIO_IO10 = 14,
	IMX91_PAD_GPIO_IO11 = 15,
	IMX91_PAD_GPIO_IO12 = 16,
	IMX91_PAD_GPIO_IO13 = 17,
	IMX91_PAD_GPIO_IO14 = 18,
	IMX91_PAD_GPIO_IO15 = 19,
	IMX91_PAD_GPIO_IO16 = 20,
	IMX91_PAD_GPIO_IO17 = 21,
	IMX91_PAD_GPIO_IO18 = 22,
	IMX91_PAD_GPIO_IO19 = 23,
	IMX91_PAD_GPIO_IO20 = 24,
	IMX91_PAD_GPIO_IO21 = 25,
	IMX91_PAD_GPIO_IO22 = 26,
	IMX91_PAD_GPIO_IO23 = 27,
	IMX91_PAD_GPIO_IO24 = 28,
	IMX91_PAD_GPIO_IO25 = 29,
	IMX91_PAD_GPIO_IO26 = 30,
	IMX91_PAD_GPIO_IO27 = 31,
	IMX91_PAD_GPIO_IO28 = 32,
	IMX91_PAD_GPIO_IO29 = 33,
	IMX91_PAD_CCM_CLKO1 = 34,
	IMX91_PAD_CCM_CLKO2 = 35,
	IMX91_PAD_CCM_CLKO3 = 36,
	IMX91_PAD_CCM_CLKO4 = 37,
	IMX91_PAD_ENET1_MDC = 38,
	IMX91_PAD_ENET1_MDIO = 39,
	IMX91_PAD_ENET1_TD3 = 40,
	IMX91_PAD_ENET1_TD2 = 41,
	IMX91_PAD_ENET1_TD1 = 42,
	IMX91_PAD_ENET1_TD0 = 43,
	IMX91_PAD_ENET1_TX_CTL = 44,
	IMX91_PAD_ENET1_TXC = 45,
	IMX91_PAD_ENET1_RX_CTL = 46,
	IMX91_PAD_ENET1_RXC = 47,
	IMX91_PAD_ENET1_RD0 = 48,
	IMX91_PAD_ENET1_RD1 = 49,
	IMX91_PAD_ENET1_RD2 = 50,
	IMX91_PAD_ENET1_RD3 = 51,
	IMX91_PAD_ENET2_MDC = 52,
	IMX91_PAD_ENET2_MDIO = 53,
	IMX91_PAD_ENET2_TD3 = 54,
	IMX91_PAD_ENET2_TD2 = 55,
	IMX91_PAD_ENET2_TD1 = 56,
	IMX91_PAD_ENET2_TD0 = 57,
	IMX91_PAD_ENET2_TX_CTL = 58,
	IMX91_PAD_ENET2_TXC = 59,
	IMX91_PAD_ENET2_RX_CTL = 60,
	IMX91_PAD_ENET2_RXC = 61,
	IMX91_PAD_ENET2_RD0 = 62,
	IMX91_PAD_ENET2_RD1 = 63,
	IMX91_PAD_ENET2_RD2 = 64,
	IMX91_PAD_ENET2_RD3 = 65,
	IMX91_PAD_SD1_CLK = 66,
	IMX91_PAD_SD1_CMD = 67,
	IMX91_PAD_SD1_DATA0 = 68,
	IMX91_PAD_SD1_DATA1 = 69,
	IMX91_PAD_SD1_DATA2 = 70,
	IMX91_PAD_SD1_DATA3 = 71,
	IMX91_PAD_SD1_DATA4 = 72,
	IMX91_PAD_SD1_DATA5 = 73,
	IMX91_PAD_SD1_DATA6 = 74,
	IMX91_PAD_SD1_DATA7 = 75,
	IMX91_PAD_SD1_STROBE = 76,
	IMX91_PAD_SD2_VSELECT = 77,
	IMX91_PAD_SD3_CLK = 78,
	IMX91_PAD_SD3_CMD = 79,
	IMX91_PAD_SD3_DATA0 = 80,
	IMX91_PAD_SD3_DATA1 = 81,
	IMX91_PAD_SD3_DATA2 = 82,
	IMX91_PAD_SD3_DATA3 = 83,
	IMX91_PAD_SD2_CD_B = 84,
	IMX91_PAD_SD2_CLK = 85,
	IMX91_PAD_SD2_CMD = 86,
	IMX91_PAD_SD2_DATA0 = 87,
	IMX91_PAD_SD2_DATA1 = 88,
	IMX91_PAD_SD2_DATA2 = 89,
	IMX91_PAD_SD2_DATA3 = 90,
	IMX91_PAD_SD2_RESET_B = 91,
	IMX91_PAD_I2C1_SCL = 92,
	IMX91_PAD_I2C1_SDA = 93,
	IMX91_PAD_I2C2_SCL = 94,
	IMX91_PAD_I2C2_SDA = 95,
	IMX91_PAD_UART1_RXD = 96,
	IMX91_PAD_UART1_TXD = 97,
	IMX91_PAD_UART2_RXD = 98,
	IMX91_PAD_UART2_TXD = 99,
	IMX91_PAD_PDM_CLK = 100,
	IMX91_PAD_PDM_BIT_STREAM0 = 101,
	IMX91_PAD_PDM_BIT_STREAM1 = 102,
	IMX91_PAD_SAI1_TXFS = 103,
	IMX91_PAD_SAI1_TXC = 104,
	IMX91_PAD_SAI1_TXD0 = 105,
	IMX91_PAD_SAI1_RXD0 = 106,
	IMX91_PAD_WDOG_ANY = 107,
};

/* Pad names for the pinmux subsystem */
static const struct pinctrl_pin_desc imx91_pinctrl_pads[] = {
	IMX_PINCTRL_PIN(IMX91_PAD_DAP_TDI),
	IMX_PINCTRL_PIN(IMX91_PAD_DAP_TMS_SWDIO),
	IMX_PINCTRL_PIN(IMX91_PAD_DAP_TCLK_SWCLK),
	IMX_PINCTRL_PIN(IMX91_PAD_DAP_TDO_TRACESWO),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO00),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO01),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO02),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO03),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO04),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO05),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO06),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO07),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO08),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO09),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO10),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO11),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO12),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO13),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO14),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO15),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO16),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO17),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO18),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO19),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO20),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO21),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO22),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO23),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO24),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO25),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO26),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO27),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO28),
	IMX_PINCTRL_PIN(IMX91_PAD_GPIO_IO29),
	IMX_PINCTRL_PIN(IMX91_PAD_CCM_CLKO1),
	IMX_PINCTRL_PIN(IMX91_PAD_CCM_CLKO2),
	IMX_PINCTRL_PIN(IMX91_PAD_CCM_CLKO3),
	IMX_PINCTRL_PIN(IMX91_PAD_CCM_CLKO4),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_MDC),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_MDIO),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_TD3),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_TD2),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_TD1),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_TD0),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_TX_CTL),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_TXC),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_RX_CTL),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_RXC),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_RD0),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_RD1),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_RD2),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET1_RD3),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_MDC),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_MDIO),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_TD3),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_TD2),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_TD1),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_TD0),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_TX_CTL),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_TXC),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_RX_CTL),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_RXC),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_RD0),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_RD1),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_RD2),
	IMX_PINCTRL_PIN(IMX91_PAD_ENET2_RD3),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_CLK),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_CMD),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA0),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA1),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA2),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA3),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA4),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA5),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA6),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_DATA7),
	IMX_PINCTRL_PIN(IMX91_PAD_SD1_STROBE),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_VSELECT),
	IMX_PINCTRL_PIN(IMX91_PAD_SD3_CLK),
	IMX_PINCTRL_PIN(IMX91_PAD_SD3_CMD),
	IMX_PINCTRL_PIN(IMX91_PAD_SD3_DATA0),
	IMX_PINCTRL_PIN(IMX91_PAD_SD3_DATA1),
	IMX_PINCTRL_PIN(IMX91_PAD_SD3_DATA2),
	IMX_PINCTRL_PIN(IMX91_PAD_SD3_DATA3),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_CD_B),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_CLK),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_CMD),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_DATA0),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_DATA1),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_DATA2),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_DATA3),
	IMX_PINCTRL_PIN(IMX91_PAD_SD2_RESET_B),
	IMX_PINCTRL_PIN(IMX91_PAD_I2C1_SCL),
	IMX_PINCTRL_PIN(IMX91_PAD_I2C1_SDA),
	IMX_PINCTRL_PIN(IMX91_PAD_I2C2_SCL),
	IMX_PINCTRL_PIN(IMX91_PAD_I2C2_SDA),
	IMX_PINCTRL_PIN(IMX91_PAD_UART1_RXD),
	IMX_PINCTRL_PIN(IMX91_PAD_UART1_TXD),
	IMX_PINCTRL_PIN(IMX91_PAD_UART2_RXD),
	IMX_PINCTRL_PIN(IMX91_PAD_UART2_TXD),
	IMX_PINCTRL_PIN(IMX91_PAD_PDM_CLK),
	IMX_PINCTRL_PIN(IMX91_PAD_PDM_BIT_STREAM0),
	IMX_PINCTRL_PIN(IMX91_PAD_PDM_BIT_STREAM1),
	IMX_PINCTRL_PIN(IMX91_PAD_SAI1_TXFS),
	IMX_PINCTRL_PIN(IMX91_PAD_SAI1_TXC),
	IMX_PINCTRL_PIN(IMX91_PAD_SAI1_TXD0),
	IMX_PINCTRL_PIN(IMX91_PAD_SAI1_RXD0),
	IMX_PINCTRL_PIN(IMX91_PAD_WDOG_ANY),
};

static const struct imx_pinctrl_soc_info imx91_pinctrl_info = {
	.pins = imx91_pinctrl_pads,
	.npins = ARRAY_SIZE(imx91_pinctrl_pads),
	.flags = ZERO_OFFSET_VALID,
};

static int imx91_pinctrl_probe(struct platform_device *pdev)
{
	return imx_pinctrl_probe(pdev, &imx91_pinctrl_info);
}

static const struct of_device_id imx91_pinctrl_of_match[] = {
	{ .compatible = "fsl,imx91-iomuxc", },
	{ /* sentinel */ }
};
MODULE_DEVICE_TABLE(of, imx91_pinctrl_of_match);

static struct platform_driver imx91_pinctrl_driver = {
	.driver = {
		.name = "imx91-pinctrl",
		.of_match_table = imx91_pinctrl_of_match,
		.suppress_bind_attrs = true,
	},
	.probe = imx91_pinctrl_probe,
};

static int __init imx91_pinctrl_init(void)
{
	return platform_driver_register(&imx91_pinctrl_driver);
}
arch_initcall(imx91_pinctrl_init);

MODULE_AUTHOR("Peng Fan <peng.fan@nxp.com>");
MODULE_DESCRIPTION("NXP i.MX91 pinctrl driver");
MODULE_LICENSE("GPL");
