; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-apple-ios %s -o - | FileCheck %s

define <16 x double> @test_sitofp_fixed(<16 x i32> %in) {
; CHECK-LABEL: test_sitofp_fixed:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    sshll2.2d v4, v2, #0
; CHECK-NEXT:    sshll.2d v16, v1, #0
; CHECK-NEXT:    sshll2.2d v5, v0, #0
; CHECK-NEXT:    sshll2.2d v6, v1, #0
; CHECK-NEXT:    sshll2.2d v7, v3, #0
; CHECK-NEXT:    sshll.2d v0, v0, #0
; CHECK-NEXT:    sshll.2d v17, v2, #0
; CHECK-NEXT:    sshll.2d v18, v3, #0
; CHECK-NEXT:    scvtf.2d v1, v5, #6
; CHECK-NEXT:    scvtf.2d v3, v6, #6
; CHECK-NEXT:    scvtf.2d v2, v16, #6
; CHECK-NEXT:    scvtf.2d v5, v4, #6
; CHECK-NEXT:    scvtf.2d v0, v0, #6
; CHECK-NEXT:    scvtf.2d v7, v7, #6
; CHECK-NEXT:    scvtf.2d v4, v17, #6
; CHECK-NEXT:    scvtf.2d v6, v18, #6
; CHECK-NEXT:    ret

  %flt = sitofp <16 x i32> %in to <16 x double>
  %res = fdiv <16 x double> %flt, <double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0, double 64.0>
  ret <16 x double> %res
}

; This one is small enough to satisfy isSimple, but still illegally large.
define <4 x double> @test_sitofp_fixed_shortish(<4 x i64> %in) {
; CHECK-LABEL: test_sitofp_fixed_shortish:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    scvtf.2d v0, v0, #6
; CHECK-NEXT:    scvtf.2d v1, v1, #6
; CHECK-NEXT:    ret


  %flt = sitofp <4 x i64> %in to <4 x double>
  %res = fdiv <4 x double> %flt, <double 64.0, double 64.0, double 64.0, double 64.0>
  ret <4 x double> %res
}
