; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=ipsccp < %s | FileCheck %s

; Test that information about the true/false value of conditions themselves
; is also used, not information implied by comparisions.

define i32 @switch(i32 %x) {
; CHECK-LABEL: @switch(
; CHECK-NEXT:    switch i32 [[X:%.*]], label [[CASE_DEFAULT:%.*]] [
; CHECK-NEXT:    i32 0, label [[CASE_0:%.*]]
; CHECK-NEXT:    i32 2, label [[CASE_2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       case.0:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       case.2:
; CHECK-NEXT:    br label [[END]]
; CHECK:       case.default:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    ret i32 1
;
  switch i32 %x, label %case.default [
  i32 0, label %case.0
  i32 2, label %case.2
  ]

case.0:
  %add = add i32 %x, 1
  br label %end

case.2:
  %sub = sub i32 %x, 1
  br label %end

case.default:
  br label %end

end:
  %phi = phi i32 [ %add, %case.0 ], [ %sub, %case.2 ], [ 1, %case.default]
  ret i32 %phi
}

define i1 @assume(i32 %x) {
; CHECK-LABEL: @assume(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[X:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    ret i1 true
;
  %cmp = icmp sge i32 %x, 0
  call void @llvm.assume(i1 %cmp)
  ret i1 %cmp
}

define i32 @branch(i32 %x) {
; CHECK-LABEL: @branch(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN1:%.*]], label [[IF_THEN2:%.*]]
; CHECK:       if.then1:
; CHECK-NEXT:    br label [[IF2_THEN1:%.*]]
; CHECK:       if2.then1:
; CHECK-NEXT:    br label [[IF2_END:%.*]]
; CHECK:       if2.end:
; CHECK-NEXT:    ret i32 0
; CHECK:       if.then2:
; CHECK-NEXT:    br label [[IF3_THEN2:%.*]]
; CHECK:       if3.then2:
; CHECK-NEXT:    br label [[IF3_END:%.*]]
; CHECK:       if3.end:
; CHECK-NEXT:    ret i32 1
;
  %cmp = icmp sge i32 %x, 0
  br i1 %cmp, label %if.then1, label %if.then2

if.then1:
  br i1 %cmp, label %if2.then1, label %if2.then2

if2.then1:
  br label %if2.end

if2.then2:
  br label %if2.end

if2.end:
  %phi = phi i32 [ 0, %if2.then1 ], [ 1, %if2.then2 ]
  ret i32 %phi

if.then2:
  br i1 %cmp, label %if3.then1, label %if3.then2

if3.then1:
  br label %if3.end

if3.then2:
  br label %if3.end

if3.end:
  %phi2 = phi i32 [ 0, %if3.then1 ], [ 1, %if3.then2 ]
  ret i32 %phi2
}

define void @pr46814(i32 %a) {
; CHECK-LABEL: @pr46814(
; CHECK-NEXT:    [[C1:%.*]] = icmp uge i32 [[A:%.*]], 10
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[A]], 20
; CHECK-NEXT:    [[C3:%.*]] = and i1 [[C1]], [[C2]]
; CHECK-NEXT:    br i1 [[C3]], label [[IF_1:%.*]], label [[EXIT:%.*]]
; CHECK:       if.1:
; CHECK-NEXT:    br label [[IF_2:%.*]]
; CHECK:       if.2:
; CHECK-NEXT:    br i1 true, label [[EXIT]], label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
  %c1 = icmp uge i32 %a, 10
  %c2 = icmp ult i32 %a, 20
  %c3 = and i1 %c1, %c2
  br i1 %c3, label %if.1, label %exit

if.1:
  br i1 %c3, label %if.2, label %exit

if.2:
  br i1 %c3, label %exit, label %exit

exit:
  ret void
}

declare void @llvm.assume(i1)
