/*
 * Copyright (c) 2015-2020 Cisco Systems, Inc.  All rights reserved
 * Copyright (c) 2019-2020 Intel, Inc.  All rights reserved.
 * Copyright (c) 2019      Research Organization for Information Science
 *                         and Technology (RIST).  All rights reserved.
 * Copyright (c) 2021-2022 Nanook Consulting.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef PRTE_DL_LIBLTDL
#define PRTE_DL_LIBLTDL

#include "prte_config.h"

#include "src/mca/prtedl/prtedl.h"

#include <ltprtedl.h>

PRTE_EXPORT extern prte_prtedl_base_module_t prte_prtedl_libltdl_module;

/*
 * Dynamic library handles generated by this component.
 *
 * If we're debugging, keep a copy of the name of the file we've opened.
 */
struct prte_dl_handle_t {
    lt_prtedlhandle ltprtedl_handle;
#if PRTE_ENABLE_DEBUG
    char *filename;
#endif
};

typedef struct {
    prte_prtedl_base_component_t base;

#if PRTE_DL_LIBLTDL_HAVE_LT_DLADVISE
    /* If the version of libltdl that we are compiling against has
       lt_dladvise, use it to support opening DSOs in a variety of
       modes. */
    lt_dladvise advise_private_noext;
    lt_dladvise advise_private_ext;
    lt_dladvise advise_public_noext;
    lt_dladvise advise_public_ext;
#endif
} prte_prtedl_libltdl_component_t;

PRTE_EXPORT extern prte_prtedl_libltdl_component_t prte_mca_prtedl_libltdl_component;

#endif /* PRTE_DL_LIBLTDL */
